/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui;

import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.WorkflowSupportManager;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.ui.editor.WorkflowDefinitionEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.sapphire.UniversalConversionService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.server.core.IServer;

public class WorkflowProjectAdapterService
extends UniversalConversionService {
    public <A> A convert(Object object, Class<A> adapterType) {
        A retval = null;
        if (IProject.class.equals(adapterType)) {
            ISapphirePart sapphirePart = (ISapphirePart)this.context().find(ISapphirePart.class);
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)sapphirePart.getLocalModelElement().nearest(WorkflowDefinition.class);
            IFile file = (IFile)workflowDefinition.adapt(IFile.class);
            if (file != null) {
                retval = adapterType.cast(file.getProject());
            } else {
                WorkflowSupportManager workflowSupportManager = KaleoCore.getDefault().getWorkflowSupportManager();
                IEditorInput editorInput = (IEditorInput)workflowDefinition.adapt(IEditorInput.class);
                if (editorInput instanceof WorkflowDefinitionEditorInput) {
                    WorkflowDefinitionEditorInput workflowInput = (WorkflowDefinitionEditorInput)editorInput;
                    IServer server = workflowInput.getWorkflowDefinitionEntry().getParent().getParent();
                    workflowSupportManager.setCurrentServer(server);
                }
                IJavaProject supportProject = workflowSupportManager.getSupportProject();
                retval = adapterType.cast(supportProject.getProject());
            }
        }
        return retval;
    }
}

