/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.action;

import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoAPIException;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.ui.action.AbstractWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionsFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IServer;

public class PublishWorkflowDefinitionAction
extends AbstractWorkflowDefinitionAction {
    public PublishWorkflowDefinitionAction(ISelectionProvider sp) {
        super(sp, "Publish Kaleo workflow");
    }

    @Override
    public void perform(Object node) {
        if (this.getSelectionProvider() instanceof CommonViewer && node instanceof WorkflowDefinitionEntry) {
            final WorkflowDefinitionEntry definitionNode = (WorkflowDefinitionEntry)node;
            Job publishJob = new Job("Publishing workflow draft definition"){

                protected IStatus run(IProgressMonitor monitor) {
                    IKaleoConnection kaleoConnection = KaleoCore.getKaleoConnection((IServer)definitionNode.getParent().getParent());
                    try {
                        kaleoConnection.publishKaleoDraftDefinition(definitionNode.getName(), definitionNode.getTitleMap(), definitionNode.getContent(), String.valueOf(definitionNode.getCompanyId()), String.valueOf(definitionNode.getUserId()), String.valueOf(definitionNode.getGroupId()));
                    }
                    catch (KaleoAPIException e) {
                        e.printStackTrace();
                    }
                    final WorkflowDefinitionsFolder definitionsFolder = definitionNode.getParent();
                    final CommonViewer viewer = (CommonViewer)PublishWorkflowDefinitionAction.this.getSelectionProvider();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            definitionsFolder.clearCache();
                            viewer.refresh(true);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            publishJob.schedule();
        }
    }
}

