/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.action;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.action.AbstractWorkflowDefinitionAction;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionsFolder;
import com.liferay.ide.kaleo.ui.util.KaleoUtil;
import com.liferay.ide.kaleo.ui.util.UploadWorkflowFileJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IServer;

public class UploadNewWorkflowDefinitionAction
extends AbstractWorkflowDefinitionAction {
    public UploadNewWorkflowDefinitionAction(ISelectionProvider sp) {
        super(sp, "Upload new workflow...");
    }

    @Override
    public void perform(Object node) {
        if (this.getSelectionProvider() instanceof CommonViewer && node instanceof WorkflowDefinitionsFolder) {
            IFile workspaceFile = this.promptForWorkspaceFile();
            if (workspaceFile == null || !workspaceFile.exists()) {
                return;
            }
            String errorMsgs = KaleoUtil.checkWorkflowDefinitionForErrors(workspaceFile);
            if (!CoreUtil.empty((String)errorMsgs)) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Upload Kaleo Workflow", (String)("Unable to upload kaleo workflow:\n\n" + errorMsgs));
                return;
            }
            final WorkflowDefinitionsFolder definitionsFolder = (WorkflowDefinitionsFolder)node;
            IKaleoConnection kaleoConnection = KaleoCore.getKaleoConnection((IServer)definitionsFolder.getParent());
            UploadWorkflowFileJob upload = new UploadWorkflowFileJob(kaleoConnection, workspaceFile, new Runnable(){

                @Override
                public void run() {
                    final CommonViewer viewer = (CommonViewer)UploadNewWorkflowDefinitionAction.this.getSelectionProvider();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            definitionsFolder.clearCache();
                            viewer.refresh(true);
                        }
                    });
                }
            });
            upload.schedule();
        }
    }

    protected IFile promptForWorkspaceFile() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle("workspace file");
        dialog.setMessage("workspace file");
        dialog.addFilter(filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return file;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    return true;
                }
                if (element instanceof IFolder) {
                    return true;
                }
                return element instanceof IFile;
            }
        };
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] != null && !(selection[0] instanceof IProject) && !(selection[0] instanceof IFolder)) {
                    return Status.OK_STATUS;
                }
                return KaleoUI.createErrorStatus("Choose a valid project file");
            }
        };
    }
}

