/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.diagram;

import com.liferay.ide.kaleo.core.model.Scriptable;
import com.liferay.ide.kaleo.core.model.Task;
import com.liferay.ide.kaleo.ui.IKaleoEditorHelper;
import com.liferay.ide.kaleo.ui.KaleoUI;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.DetailSectionPart;

public class ScriptableOpenActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        try {
            Scriptable scriptable = this.scriptable(context);
            if (scriptable != null) {
                IKaleoEditorHelper kaleoEditorHelper = KaleoUI.getKaleoEditorHelper(scriptable.getScriptLanguage().text(true));
                kaleoEditorHelper.openEditor((ISapphirePart)context.part(), (Element)scriptable, Scriptable.PROP_SCRIPT);
            }
        }
        catch (Exception e) {
            KaleoUI.logError("Could not open script editor.", e);
        }
        return null;
    }

    protected Scriptable scriptable(Presentation context) {
        Scriptable retval = null;
        SapphirePart part = context.part();
        if (part instanceof DetailSectionPart) {
            DetailSectionPart pageBook = (DetailSectionPart)part.nearest(DetailSectionPart.class);
            retval = (Scriptable)pageBook.getCurrentPage().getLocalModelElement().nearest(Scriptable.class);
        } else {
            Element modelElement = context.part().getLocalModelElement();
            retval = modelElement instanceof Task ? (Scriptable)((Task)modelElement.nearest(Task.class)).getScriptedAssignment().content(false) : (Scriptable)modelElement.nearest(Scriptable.class);
        }
        return retval;
    }
}

