/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.navigator;

import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionsFolder;
import com.liferay.ide.kaleo.ui.util.KaleoUtil;
import com.liferay.ide.server.core.ILiferayServer;
import com.liferay.ide.server.ui.PluginsCustomContentProvider;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.wst.server.core.IServer;

public class WorkflowDefinitionsCustomContentProvider
extends PluginsCustomContentProvider {
    protected static final Object[] EMPTY = new Object[0];
    private final Map<String, WorkflowDefinitionsFolder> workflowDefinitionFolders = new HashMap<String, WorkflowDefinitionsFolder>();
    private final Map<String, IStatus> checkApiStatuses = new HashMap<String, IStatus>();

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IServer) {
            return null;
        }
        if (parentElement instanceof WorkflowDefinitionsFolder) {
            return ((WorkflowDefinitionsFolder)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IWorkspaceRoot) {
            return null;
        }
        return null;
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        if (parent instanceof IServer) {
            final IServer server = (IServer)parent;
            if (server.getServerState() == 2) {
                WorkflowDefinitionsFolder definitionsNode = this.workflowDefinitionFolders.get(server.getId());
                if (definitionsNode == null) {
                    IStatus checkApiStatus = this.checkApiStatuses.get(server.getId());
                    if (checkApiStatus == null) {
                        Job checkJob = new Job("Checking for Kaleo Designer API..."){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    IKaleoConnection kaleoConnection = KaleoCore.getKaleoConnection((IServer)server);
                                    KaleoCore.updateKaleoConnectionSettings((ILiferayServer)KaleoUtil.getLiferayServer(server, monitor), (IKaleoConnection)kaleoConnection);
                                    kaleoConnection.getKaleoDefinitions();
                                    kaleoConnection.getKaleoDraftWorkflowDefinitions();
                                    WorkflowDefinitionsCustomContentProvider.this.checkApiStatuses.put(server.getId(), Status.OK_STATUS);
                                    WorkflowDefinitionsCustomContentProvider.this.refreshUI((NavigatorContentService)WorkflowDefinitionsCustomContentProvider.this.getConfig().getService(), server);
                                }
                                catch (Exception e) {
                                    WorkflowDefinitionsCustomContentProvider.this.checkApiStatuses.put(server.getId(), KaleoUI.createErrorStatus(e));
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        checkJob.schedule();
                    } else if (checkApiStatus.isOK()) {
                        this.insertDefinitionsNode(server, currentChildren);
                        this.checkApiStatuses.put(server.getId(), null);
                    } else {
                        KaleoUI.logInfo("Kaleo Workflow API unavailable.", checkApiStatus);
                    }
                } else if (!currentChildren.contains(definitionsNode)) {
                    currentChildren.add(definitionsNode);
                    definitionsNode.getChildren();
                }
            } else {
                this.workflowDefinitionFolders.put(server.getId(), null);
                this.checkApiStatuses.put(server.getId(), null);
            }
        }
    }

    protected void refreshUI(final NavigatorContentService s, final IServer server) {
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CommonViewer viewer = (CommonViewer)s.getViewer();
                    viewer.refresh(true);
                    viewer.setExpandedState((Object)server, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        if (object instanceof WorkflowDefinitionsFolder) {
            return ((WorkflowDefinitionsFolder)object).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof WorkflowDefinitionsFolder;
    }

    public boolean hasChildren(Object element, boolean currentHasChildren) {
        if (element instanceof IServer) {
            if (currentHasChildren) {
                return true;
            }
            IServer server = (IServer)element;
            WorkflowDefinitionsFolder definitionsNode = this.workflowDefinitionFolders.get(server.getId());
            if (definitionsNode != null) {
                return true;
            }
            if (ServerUtil.isLiferayRuntime((IServer)server) && server.getServerState() == 2) {
                return true;
            }
        }
        return currentHasChildren;
    }

    private void insertDefinitionsNode(IServer server, Set currentChildren) {
        WorkflowDefinitionsFolder node = new WorkflowDefinitionsFolder(this.getConfig(), server);
        this.workflowDefinitionFolders.put(server.getId(), node);
        currentChildren.add(node);
    }

    public boolean interceptRefresh(PipelinedViewerUpdate viewerUpdate) {
        for (Object refreshTarget : viewerUpdate.getRefreshTargets()) {
            if (!(refreshTarget instanceof IServer)) continue;
            this.clearStatuses((IServer)refreshTarget);
        }
        return false;
    }

    private void clearStatuses(IServer server) {
        if (ServerUtil.isLiferayRuntime((IServer)server) && server.getServerState() != 2) {
            this.checkApiStatuses.put(server.getId(), null);
        }
    }

    public boolean interceptUpdate(PipelinedViewerUpdate viewerUpdate) {
        for (Object updateTarget : viewerUpdate.getRefreshTargets()) {
            if (!(updateTarget instanceof IServer)) continue;
            this.clearStatuses((IServer)updateTarget);
        }
        return false;
    }
}

