/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.ui.navigator;

import com.liferay.ide.kaleo.core.IKaleoConnection;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.ui.KaleoUI;
import com.liferay.ide.kaleo.ui.navigator.WorkflowDefinitionEntry;
import com.liferay.ide.kaleo.ui.util.KaleoUtil;
import com.liferay.ide.server.core.ILiferayServer;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.wst.server.core.IServer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkflowDefinitionsFolder {
    private WorkflowDefinitionEntry[] cachedDefinitions;
    private Job cacheDefinitionsJob;
    private IStatus currentStatus;
    private IServer input;
    private ICommonContentExtensionSite site;

    public WorkflowDefinitionsFolder(ICommonContentExtensionSite site, IServer server) {
        this.site = site;
        this.input = server;
        KaleoCore.updateKaleoConnectionSettings((ILiferayServer)this.getLiferayServer());
        this.scheduleCacheDefinitionsJob();
    }

    public void clearCache() {
        this.cachedDefinitions = null;
    }

    private Object createLoadingNode() {
        WorkflowDefinitionEntry node = new WorkflowDefinitionEntry();
        node.setLoadingNode(true);
        return node;
    }

    public Object[] getChildren() {
        if (this.input.getServerState() != 2) {
            return null;
        }
        if (this.getLiferayServer() == null) {
            return null;
        }
        if (this.cachedDefinitions == null) {
            this.scheduleCacheDefinitionsJob();
            return new Object[]{this.createLoadingNode()};
        }
        return this.cachedDefinitions;
    }

    private ILiferayServer getLiferayServer() {
        return (ILiferayServer)this.input.loadAdapter(ILiferayServer.class, null);
    }

    public IServer getParent() {
        return this.input;
    }

    public IStatus getStatus() {
        return this.currentStatus;
    }

    private boolean same(JSONObject json1, JSONObject json2, String field) throws JSONException {
        return json1 != null && json2 != null && json1.get(field) != null && json1.get(field).equals(json2.get(field));
    }

    private void scheduleCacheDefinitionsJob() {
        if (this.cacheDefinitionsJob == null) {
            this.cacheDefinitionsJob = new Job("Loading kaleo workflows..."){

                protected IStatus run(IProgressMonitor monitor) {
                    WorkflowDefinitionsFolder.this.currentStatus = KaleoUI.createInfoStatus("Loading kaleo workflows...");
                    WorkflowDefinitionsFolder.this.site.getService().update();
                    IKaleoConnection kaleoConnection = KaleoCore.getKaleoConnection((ILiferayServer)WorkflowDefinitionsFolder.this.getLiferayServer());
                    ArrayList<WorkflowDefinitionEntry> definitionEntries = new ArrayList<WorkflowDefinitionEntry>();
                    IStatus errorStatus = null;
                    try {
                        JSONArray kaleoDefinitions = kaleoConnection.getKaleoDefinitions();
                        JSONArray kaleoDraftDefinitions = kaleoConnection.getKaleoDraftWorkflowDefinitions();
                        int i = 0;
                        while (i < kaleoDefinitions.length()) {
                            JSONObject definition = (JSONObject)kaleoDefinitions.get(i);
                            WorkflowDefinitionEntry definitionEntry = WorkflowDefinitionEntry.createFromJSONObject(definition);
                            definitionEntry.setParent(WorkflowDefinitionsFolder.this);
                            if (kaleoDraftDefinitions != null) {
                                int j = 0;
                                while (j < kaleoDraftDefinitions.length()) {
                                    JSONObject draftDefinition = kaleoDraftDefinitions.getJSONObject(j);
                                    if (WorkflowDefinitionsFolder.this.same(definition, draftDefinition, "name") && WorkflowDefinitionsFolder.this.same(definition, draftDefinition, "version") && definitionEntry.getDraftVersion() < draftDefinition.getInt("draftVersion")) {
                                        if (draftDefinition.has("title")) {
                                            definitionEntry.setTitle(draftDefinition.getString("title"));
                                        }
                                        if (draftDefinition.has("titleMap")) {
                                            definitionEntry.setTitleMap(draftDefinition.getString("titleMap"));
                                        } else {
                                            definitionEntry.setTitleMap(KaleoUtil.createJSONTitleMap(definitionEntry.getTitle()));
                                        }
                                        definitionEntry.setCompanyId(draftDefinition.getLong("companyId"));
                                        definitionEntry.setContent(draftDefinition.getString("content"));
                                        definitionEntry.setDraftVersion(draftDefinition.getInt("draftVersion"));
                                        definitionEntry.setTitleCurrentValue(draftDefinition.getString("titleCurrentValue"));
                                        definitionEntry.setUserId(draftDefinition.getLong("userId"));
                                        definitionEntry.setGroupId(draftDefinition.getLong("groupId"));
                                        definitionEntry.setLocation(String.valueOf(kaleoConnection.getHost()) + ":" + kaleoConnection.getHttpPort());
                                    }
                                    ++j;
                                }
                            }
                            definitionEntries.add(definitionEntry);
                            ++i;
                        }
                        if (kaleoDraftDefinitions != null) {
                            i = 0;
                            while (i < kaleoDraftDefinitions.length()) {
                                JSONObject draftDefinition = kaleoDraftDefinitions.getJSONObject(i);
                                WorkflowDefinitionEntry draftEntry = null;
                                for (WorkflowDefinitionEntry entry : definitionEntries) {
                                    if (!entry.getName().equals(draftDefinition.getString("name")) || entry.getVersion() != draftDefinition.getInt("version")) continue;
                                    draftEntry = entry;
                                    if (entry.getDraftVersion() >= draftDefinition.getInt("draftVersion")) continue;
                                    entry.setCompanyId(draftDefinition.getLong("companyId"));
                                    entry.setContent(draftDefinition.getString("content"));
                                    entry.setDraftVersion(draftDefinition.getInt("draftVersion"));
                                    entry.setTitleCurrentValue(draftDefinition.getString("titleCurrentValue"));
                                    entry.setUserId(draftDefinition.getLong("userId"));
                                    entry.setLocation(String.valueOf(kaleoConnection.getHost()) + ":" + kaleoConnection.getHttpPort());
                                }
                                ++i;
                            }
                        }
                        WorkflowDefinitionsFolder.this.cachedDefinitions = definitionEntries.toArray(new WorkflowDefinitionEntry[0]);
                    }
                    catch (Exception e) {
                        errorStatus = KaleoUI.createErrorStatus(e);
                    }
                    if (errorStatus != null) {
                        WorkflowDefinitionsFolder.this.currentStatus = errorStatus;
                    } else {
                        WorkflowDefinitionsFolder.this.currentStatus = null;
                    }
                    WorkflowDefinitionsFolder.this.site.getService().update();
                    WorkflowDefinitionsFolder.this.cacheDefinitionsJob = null;
                    return Status.OK_STATUS;
                }
            };
            this.cacheDefinitionsJob.schedule();
        }
    }
}

