/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.internal.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.util.FileUtils;
import org.eclipse.wst.xml.search.editor.internal.indexing.XMLReferencesIndexManager;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;

class XMLReferencesFileVisitor
implements IResourceProxyVisitor {
    private final IProgressMonitor monitor;
    private final Map<String, Collection<IFile>> files;

    public XMLReferencesFileVisitor(Map<String, Collection<IFile>> files, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.files = files;
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        IResource resource;
        String contentTypeId;
        if (this.monitor != null && this.monitor.isCanceled()) {
            return false;
        }
        if (proxy.getType() == 1 && this.isXMLFile(proxy.getName()) && (contentTypeId = this.isXMLReferenceResource(resource = proxy.requestResource())) != null) {
            IFile file = (IFile)resource;
            if (XMLReferencesIndexManager.DEBUG) {
                System.out.println("(+) XMLReferencesFileVisitor adding file: " + file.getName());
            }
            this.addXMLFile(file, contentTypeId, this.files);
            this.monitor.subTask(proxy.getName());
            return false;
        }
        return true;
    }

    private boolean isXMLFile(String filename) {
        return FileUtils.isXMLFile((String)filename);
    }

    private String isXMLReferenceResource(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (!resource.exists()) {
            return null;
        }
        if (resource.getType() != 1) {
            return null;
        }
        Collection<String> contentTypeIds = XMLReferencesManager.getInstance().getContentTypeIds();
        String contentTypeId = DOMUtils.getStructuredModelContentTypeId((IFile)((IFile)resource));
        if (contentTypeId == null) {
            return null;
        }
        if (contentTypeIds.contains(contentTypeId)) {
            return contentTypeId;
        }
        return null;
    }

    public void addXMLFile(IFile file, String contentTypeId, Map<String, Collection<IFile>> indexedFiles) {
        if (!file.isAccessible()) {
            return;
        }
        Collection<IFile> f = indexedFiles.get(contentTypeId);
        if (f == null) {
            f = new ArrayList<IFile>();
            indexedFiles.put(contentTypeId, f);
        }
        if (!f.contains(file)) {
            f.add(file);
        }
        if (XMLReferencesIndexManager.DEBUG) {
            System.out.println("adding XML file:" + file.getFullPath());
        }
    }
}

