/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.SimpleXMLSearchEngine;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;
import org.eclipse.wst.xml.search.core.xpath.XPathProcessorManager;
import org.eclipse.wst.xml.search.editor.internal.reporter.XMLSearchReporterManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceTo;
import org.eclipse.wst.xml.search.editor.references.IXMLReferenceToXML;
import org.eclipse.wst.xml.search.editor.util.XMLQuerySpecificationUtil;

public class XMLSearcherForXMLUtils {
    public static void search(Object selectedNode, String mathingString, IFile file, IXMLReferenceTo referenceTo, IXMLSearchDOMNodeCollector collector, boolean startsWith) {
        if (referenceTo.getType() != IXMLReferenceTo.ToType.XML) {
            return;
        }
        IXMLReferenceToXML referencePath = (IXMLReferenceToXML)referenceTo;
        IXMLQuerySpecification querySpecification = XMLQuerySpecificationUtil.getQuerySpecification(referencePath);
        if (querySpecification != null) {
            String xpathProcessorId = querySpecification.getXPathProcessorId();
            if (xpathProcessorId == null) {
                IXPathProcessorType processor = XPathProcessorManager.getDefault().getDefaultProcessor();
                xpathProcessorId = processor != null ? processor.getId() : null;
            }
            String xpath = null;
            xpath = startsWith ? referencePath.getQuery(selectedNode, mathingString, querySpecification.getStartsWithStringQueryBuilder()) : referencePath.getQuery(selectedNode, mathingString, querySpecification.getEqualsStringQueryBuilder());
            Namespaces namespaceInfos = referencePath.getNamespaces();
            if (querySpecification.isMultiResource()) {
                SimpleXMLSearchEngine.getDefault().search(querySpecification.getResources(selectedNode, (IResource)file), querySpecification.getRequestor(), querySpecification.getVisitor(), xpath, xpathProcessorId, namespaceInfos, collector, selectedNode, (IXMLSearchReporter)XMLSearchReporterManager.getDefault(), null);
            } else {
                SimpleXMLSearchEngine.getDefault().search(querySpecification.getResource(selectedNode, (IResource)file), querySpecification.getRequestor(), querySpecification.getVisitor(), xpath, xpathProcessorId, namespaceInfos, collector, selectedNode, (IXMLSearchReporter)XMLSearchReporterManager.getDefault(), null);
            }
            if (querySpecification.isMultiStorage()) {
                SimpleXMLSearchEngine.getDefault().search(querySpecification.getStorages(selectedNode, (IResource)file), querySpecification.getRequestor(), querySpecification.getVisitor(), xpath, xpathProcessorId, namespaceInfos, collector, selectedNode, (IXMLSearchReporter)XMLSearchReporterManager.getDefault(), null);
            } else if (querySpecification.isSimpleStorage()) {
                SimpleXMLSearchEngine.getDefault().search(querySpecification.getStorage(selectedNode, (IResource)file), querySpecification.getRequestor(), querySpecification.getVisitor(), xpath, xpathProcessorId, namespaceInfos, collector, selectedNode, (IXMLSearchReporter)XMLSearchReporterManager.getDefault(), null);
            }
        }
    }
}

