/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.editor.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.EqualsStringQueryBuilder;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.core.xpath.XPathManager;
import org.eclipse.wst.xml.search.editor.internal.Trace;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferenceContainer;
import org.eclipse.wst.xml.search.editor.internal.references.XMLReferencesManager;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.eclipse.wst.xml.search.editor.references.IXMLReferencePath;
import org.eclipse.wst.xml.search.editor.validation.LocalizedMessage;
import org.w3c.dom.NodeList;

public class XMLReferencesBatchValidator
extends AbstractValidator
implements IValidatorJob {
    static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.search.editor/debug/validator"));
    private Collection<IResource> fDependsOn;

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        if (helper instanceof IWorkbenchContext) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void validateFile(IFile file, IReporter reporter) {
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "", e);
        }
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                if (reporter.isCancelled() || model == null || !(model instanceof IDOMModel)) return;
                reporter.removeAllMessages((IValidator)this, (Object)file);
                this.performValidation(file, reporter, (IDOMModel)model);
                return;
            }
            catch (IOException e) {
                Trace.trace((byte)3, "", e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                Trace.trace((byte)3, "", e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    XMLReferencesBatchValidator.this.doValidate(helper, reporter);
                }
                catch (ValidationException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xml.search.editor", 0, "org.eclipse.wst.xml.search.editor", (Throwable)e));
                }
            }
        };
        try {
            JavaCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException((IMessage)new LocalizedMessage(3, e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.doValidate(helper, reporter);
    }

    void doValidate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        if (uris.length > 0) {
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                if (currentFile != null && currentFile.exists()) {
                    if (XMLReferencesBatchValidator.shouldValidate(currentFile)) {
                        LocalizedMessage message = new LocalizedMessage(4, currentFile.getFullPath().toString().substring(1));
                        reporter.displaySubtask((IValidator)this, (IMessage)message);
                        this.validateFile(currentFile, reporter);
                    }
                    if (DEBUG) {
                        System.out.println("validating: [" + uris[i] + "]");
                    }
                }
                ++i;
            }
        }
    }

    private static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    void addDependsOn(IResource resource) {
        this.fDependsOn.add(resource);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        this.fDependsOn = new HashSet<IResource>();
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                XMLReferencesBatchValidator.this.validateFile((IFile)resource, reporter);
                result.setDependsOn(XMLReferencesBatchValidator.this.fDependsOn.toArray(new IResource[XMLReferencesBatchValidator.this.fDependsOn.size()]));
                XMLReferencesBatchValidator.this.fDependsOn.clear();
            }
        };
        Job currentJob = Job.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        try {
            JavaCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "", e);
        }
        return result;
    }

    private void performValidation(IFile file, IReporter reporter, IDOMModel model) {
        if (reporter.isCancelled()) {
            return;
        }
        XMLReferenceContainer container = XMLReferencesManager.getInstance().getXMLReferenceContainer(model.getContentTypeIdentifier());
        if (container == null) {
            return;
        }
        Collection<IXMLReference> allReferences = container.getAllXMLReferences();
        if (allReferences.isEmpty()) {
            return;
        }
        IDOMDocument document = model.getDocument();
        NamespaceInfos namespaceInfos = XPathManager.getManager().getNamespaceInfo(document);
        for (IXMLReference reference : allReferences) {
            String[] targetNodes;
            IXMLReferencePath from = reference.getFrom();
            if (from.hasWildCard()) continue;
            String path = from.getPath();
            String[] stringArray = targetNodes = from.getTargetNodes();
            int n = targetNodes.length;
            int n2 = 0;
            while (n2 < n) {
                String targetNode = stringArray[n2];
                String xpath = String.valueOf(EqualsStringQueryBuilder.INSTANCE.build(path, null, null)) + (targetNode.isEmpty() ? targetNode : "/" + targetNode);
                try {
                    NodeList list = XPathManager.getManager().evaluateNodeSet(null, (Object)document, xpath, namespaceInfos, null);
                    int i = 0;
                    while (i < list.getLength()) {
                        IDOMNode n3 = (IDOMNode)list.item(i);
                        reference.getValidator().validate(reference, n3, file, (IValidator)this, reporter, true);
                        ++i;
                    }
                }
                catch (XPathExpressionException e) {
                    Trace.trace((byte)3, "", e);
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ Collection access$0(XMLReferencesBatchValidator xMLReferencesBatchValidator) {
        return xMLReferencesBatchValidator.fDependsOn;
    }
}

