/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.ui;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.ILiferayProjectAdapter;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.FacetedMavenProject;
import com.liferay.ide.maven.core.IMavenProject;
import com.liferay.ide.maven.ui.MavenUIProjectBuilder;
import com.liferay.ide.project.core.IProjectBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class MavenProjectAdapter
implements ILiferayProjectAdapter {
    private static Pattern majorMinor = Pattern.compile("([0-9]+)\\.([0-9]+).*");

    public <T> T adapt(ILiferayProject liferayProject, Class<T> adapterType) {
        String version;
        ILiferayPortal portal;
        if (liferayProject instanceof IMavenProject && IProjectBuilder.class.equals(adapterType) && (portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class)) != null && !CoreUtil.isNullOrEmpty((String)(version = portal.getVersion()))) {
            Version portalVersion;
            Matcher matcher = majorMinor.matcher(version);
            String matchedVersion = null;
            if (matcher.find() && matcher.groupCount() == 2) {
                matchedVersion = String.valueOf(matcher.group(1)) + "." + matcher.group(2) + ".0";
            }
            if (CoreUtil.compareVersions((Version)(portalVersion = new Version(matchedVersion != null ? matchedVersion : version)), (Version)ILiferayConstants.V620) < 0) {
                MavenUIProjectBuilder builder = new MavenUIProjectBuilder((IMavenProject)((FacetedMavenProject)liferayProject));
                return adapterType.cast((Object)builder);
            }
        }
        return null;
    }
}

