/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.ui.action;

import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.maven.ui.LiferayMavenUI;
import com.liferay.ide.maven.ui.MavenUIProjectBuilder;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.ui.action.AbstractObjectAction;
import org.apache.maven.model.Plugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

public abstract class MavenGoalAction
extends AbstractObjectAction {
    Plugin plugin = null;

    protected abstract String getMavenGoals();

    protected String getPluginKey() {
        return "";
    }

    protected String getGroupId() {
        return "com.liferay";
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            IFile pomXml = null;
            IProject project = null;
            Object elem = elems[0];
            if (elem instanceof IFile) {
                pomXml = (IFile)elem;
                project = pomXml.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
                pomXml = project.getFile("pom.xml");
            }
            if (pomXml.exists()) {
                final IProject p = project;
                final IFile pomXmlFile = pomXml;
                try {
                    this.plugin = MavenUtil.getPlugin((IMavenProjectFacade)MavenUtil.getProjectFacade((IProject)p), (String)"com.liferay.maven.plugins:liferay-maven-plugin", (IProgressMonitor)new NullProgressMonitor());
                    if (this.plugin == null) {
                        this.plugin = MavenUtil.getPlugin((IMavenProjectFacade)MavenUtil.getProjectFacade((IProject)p), (String)(String.valueOf(this.getGroupId()) + ":" + this.getPluginKey()), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                Job job = new Job(String.valueOf(p.getName()) + " - " + this.getMavenGoals()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            if (MavenGoalAction.this.plugin == null) {
                                return ProjectUI.createErrorStatus((String)("Can't find any plugins for " + MavenGoalAction.this.getMavenGoals()));
                            }
                            monitor.beginTask(MavenGoalAction.this.getMavenGoals(), 100);
                            MavenGoalAction.this.runMavenGoal(pomXmlFile, MavenGoalAction.this.getMavenGoals(), monitor);
                            monitor.worked(80);
                            p.refreshLocal(2, monitor);
                            monitor.worked(10);
                            MavenGoalAction.this.updateProject(p, monitor);
                            monitor.worked(10);
                        }
                        catch (Exception e) {
                            return ProjectUI.createErrorStatus((String)("Error running Maven goal " + MavenGoalAction.this.getMavenGoals()), (Exception)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    private void runMavenGoal(IFile pomFile, String goal, IProgressMonitor monitor) throws CoreException {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade projectFacade = projectManager.create(pomFile, false, (IProgressMonitor)new NullProgressMonitor());
        MavenUIProjectBuilder builder = new MavenUIProjectBuilder(pomFile.getProject());
        builder.runMavenGoal(projectFacade, goal, "run", monitor);
    }

    protected void updateProject(IProject p, IProgressMonitor monitor) {
        try {
            p.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            LiferayMavenUI.logError("Error refreshing project after " + this.getMavenGoals(), e);
        }
    }
}

