/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.Proposals;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.MethodHandleUtils;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.swt.graphics.Image;

public class ProcessableParameterGuessingProposal
extends ParameterGuessingProposal
implements IProcessableProposal {
    private final Map<IProposalTag, Object> tags = Maps.newHashMap();
    private final CompletionProposal coreProposal;
    private ProposalProcessorManager mgr;
    private String lastPrefix;
    private String lastPrefixStyled;
    private StyledString initialDisplayString;
    private static final Field JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_CORE_CONTEXT = (Field)Reflections.getDeclaredField((boolean)true, JavaContentAssistInvocationContext.class, (String)"fCoreContext").orNull();
    private static final Field JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_COLLECTOR = (Field)Reflections.getDeclaredField((boolean)true, JavaContentAssistInvocationContext.class, (String)"fCollector").orNull();
    private static final Field COMPLETION_PROPOSAL_COLLECTOR_F_CONTEXT = (Field)Reflections.getDeclaredField((boolean)true, CompletionProposalCollector.class, (String)"fContext").orNull();
    private static MethodHandle GET_PATTERN_TO_EMPHASIZE_MATCH_SUPER_METHOD = (MethodHandle)MethodHandleUtils.getSuperMethodHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getPatternToEmphasizeMatch", String.class, (Class[])new Class[]{IDocument.class, Integer.TYPE}).orNull();

    protected ProcessableParameterGuessingProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context, boolean fillBestGuess) {
        super(proposal, context, context.getCoreContext(), fillBestGuess);
        this.coreProposal = proposal;
    }

    protected LazyJavaCompletionProposal createRequiredTypeCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext invocationContext) {
        if (!Checks.anyIsNull((Object[])new Object[]{JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_CORE_CONTEXT, JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_COLLECTOR, COMPLETION_PROPOSAL_COLLECTOR_F_CONTEXT})) {
            try {
                CompletionContext oldCoreContext = (CompletionContext)JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_CORE_CONTEXT.get(invocationContext);
                if (!oldCoreContext.isExtended()) {
                    CompletionProposalCollector collector = (CompletionProposalCollector)JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_COLLECTOR.get(invocationContext);
                    CompletionContext newCoreContext = (CompletionContext)COMPLETION_PROPOSAL_COLLECTOR_F_CONTEXT.get(collector);
                    JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_CORE_CONTEXT.set(invocationContext, newCoreContext);
                    LazyJavaCompletionProposal proposal = super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
                    JAVA_CONTENT_ASSIST_INVOCATION_CONTEXT_F_CORE_CONTEXT.set(invocationContext, oldCoreContext);
                    return proposal;
                }
                return super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                return super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
            }
        }
        return super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
    }

    protected Image computeImage() {
        Image image = super.computeImage();
        return this.mgr.decorateImage(image);
    }

    @Override
    public StyledString getStyledDisplayString() {
        StyledString decorated;
        StyledString copy;
        if (this.initialDisplayString == null) {
            this.initialDisplayString = super.getStyledDisplayString();
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        if (this.lastPrefixStyled != this.lastPrefix) {
            this.lastPrefixStyled = this.lastPrefix;
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        return super.getStyledDisplayString();
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        boolean res = this.mgr.prefixChanged(prefix) || super.isPrefix(prefix, completion);
        this.setTag(ProposalTag.IS_VISIBLE, res);
        return res;
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> Optional<T> getTag(String key) {
        return Proposals.getTag((ICompletionProposal)this, key);
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }

    @Override
    public <T> T getTag(String key, T defaultValue) {
        return (T)this.getTag(key).or(defaultValue);
    }

    @Override
    public ImmutableSet<IProposalTag> tags() {
        return ImmutableSet.copyOf(this.tags.keySet());
    }

    protected String getPatternToEmphasizeMatch(IDocument document, int offset) {
        if (this.getTag(ProposalTag.IS_HIGHLIGHTED, Boolean.valueOf(false)).booleanValue() || GET_PATTERN_TO_EMPHASIZE_MATCH_SUPER_METHOD == null) {
            return null;
        }
        try {
            return GET_PATTERN_TO_EMPHASIZE_MATCH_SUPER_METHOD.invokeExact(this, document, offset);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

