/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.ui.editor.PropertyCompletionProposal;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class LiferayPropertiesContentAssistProcessor
implements IContentAssistProcessor {
    private final char[] AUTO_CHARS = new char[]{'.'};
    private final PropKey[] propKeys;

    public LiferayPropertiesContentAssistProcessor(PropKey[] propKeys, String contentType) {
        this.propKeys = propKeys;
        if (CoreUtil.isNullOrEmpty((Object[])propKeys)) {
            throw new IllegalArgumentException("propKeys can not be empty");
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ITypedRegion p;
        ICompletionProposal[] retval = null;
        String currentPartitionType = null;
        IDocument document = viewer.getDocument();
        IDocumentPartitioner partitioner = this.getPartitioner(document);
        if (partitioner != null && (p = partitioner.getPartition(offset)) != null) {
            currentPartitionType = p.getType();
        }
        if (currentPartitionType != null && currentPartitionType.equals("__dftl_partition_content_type")) {
            int rewindOffset = this.rewindOffsetToNearestNonDefaultPartition(partitioner, offset);
            String partialKey = this.getPartialKey(document, rewindOffset, offset);
            ArrayList<PropertyCompletionProposal> proposals = new ArrayList<PropertyCompletionProposal>();
            if (this.propKeys != null) {
                PropKey[] propKeyArray = this.propKeys;
                int n = this.propKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    PropKey key = propKeyArray[n2];
                    if (partialKey != null && key.getKey().startsWith(partialKey)) {
                        proposals.add(new PropertyCompletionProposal(key.getKey(), key.getComment(), offset, rewindOffset));
                    }
                    ++n2;
                }
            }
            retval = proposals.toArray(new ICompletionProposal[0]);
        }
        return retval;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.AUTO_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "Unable to get keys from portal.properties";
    }

    private String getPartialKey(IDocument document, int rewindOffset, int offset) {
        String retval = null;
        if (rewindOffset < offset) {
            // empty if block
        }
        try {
            if (rewindOffset > 0) {
                --rewindOffset;
            }
            retval = document.get(rewindOffset, offset - rewindOffset).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private IDocumentPartitioner getPartitioner(IDocument document) {
        IDocumentPartitioner retval = null;
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 doc3 = (IDocumentExtension3)document;
            retval = doc3.getDocumentPartitioner("___pf_partitioning");
        }
        return retval;
    }

    private int rewindOffsetToNearestNonDefaultPartition(IDocumentPartitioner partitioner, int initialOffset) {
        int offset = initialOffset;
        ITypedRegion partition = partitioner.getPartition(offset);
        while (offset > 0 && partition != null && "__dftl_partition_content_type".equals(partition.getType())) {
            partition = partitioner.getPartition(--offset);
        }
        if (offset > 0 && offset < initialOffset) {
            ++offset;
        }
        return offset;
    }

    public static class PropKey {
        private final String comment;
        private final String key;

        PropKey(String key, String comment) {
            this.key = key;
            this.comment = comment;
        }

        String getComment() {
            return this.comment;
        }

        String getKey() {
            return this.key;
        }
    }
}

