/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.op.NewNodeOp;
import com.liferay.ide.kaleo.core.op.NewWorkflowDefinitionOp;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class EmailAddressValidationService
extends ValidationService {
    static final Pattern emailAddressPattern = Pattern.compile("[^@]+@[^\\.]+\\..+");
    private boolean shouldValidate;

    protected void initValidationService() {
        super.initValidationService();
        Version schemaVersion = this.getSchemaVersion();
        this.shouldValidate = schemaVersion.compareTo(new Version("6.2")) >= 0;
    }

    private Version getSchemaVersion() {
        NewWorkflowDefinitionOp newWorkflowDenitionOp;
        IProject project;
        ILiferayProject liferayProj;
        ILiferayPortal portal;
        Version schemaVersion = new Version("7.0.0");
        if (this.context(WorkflowDefinition.class) != null) {
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)this.context(WorkflowDefinition.class);
            schemaVersion = (Version)workflowDefinition.getSchemaVersion().content();
        } else if (this.context(NewNodeOp.class) != null) {
            NewNodeOp newNodeOp = (NewNodeOp)this.context(NewNodeOp.class);
            schemaVersion = (Version)((WorkflowDefinition)newNodeOp.getWorkflowDefinition().content()).getSchemaVersion().content();
        } else if (this.context(NewWorkflowDefinitionOp.class) != null && (portal = (ILiferayPortal)(liferayProj = LiferayCore.create((Object)(project = (IProject)(newWorkflowDenitionOp = (NewWorkflowDefinitionOp)this.context(NewWorkflowDefinitionOp.class)).getProject().target()))).adapt(ILiferayPortal.class)) != null) {
            schemaVersion = new Version(portal.getVersion());
        }
        return schemaVersion;
    }

    protected Status compute() {
        Value value;
        Status retval = Status.createOkStatus();
        if (this.shouldValidate && !(value = (Value)this.context(Value.class)).empty() && !emailAddressPattern.matcher(value.content().toString()).matches()) {
            retval = Status.createErrorStatus((String)"Email address syntax is not valid");
        }
        return retval;
    }
}

