/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.kaleo.core.model.Role;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.model.internal.RoleNamePossibleValuesMetaService;
import com.liferay.ide.kaleo.core.op.AssignableOp;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;

public class RoleNamePossibleValuesService
extends PossibleValuesService {
    private RoleNamePossibleValuesMetaService metaService;
    private String previousRoleName;
    private String currentRoleName;
    private Listener metaRoleNamesListener;
    private Listener roleNameListener;

    protected void initPossibleValuesService() {
        this.invalidValueSeverity = Status.Severity.OK;
        this.metaService = (RoleNamePossibleValuesMetaService)this.context().service(RoleNamePossibleValuesMetaService.class);
        this.previousRoleName = "";
        this.currentRoleName = "";
        this.initMetaServiceIfNecessary();
        this.metaRoleNamesListener = new FilteredListener<Event>(){

            protected void handleTypedEvent(Event event) {
                if (!((Role)RoleNamePossibleValuesService.this.context(Role.class)).disposed()) {
                    try {
                        RoleNamePossibleValuesService.this.refresh();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.roleNameListener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (!event.property().element().disposed()) {
                    RoleNamePossibleValuesService.this.currentRoleName = (String)((Role)event.property().element().nearest(Role.class)).getName().content();
                    RoleNamePossibleValuesService.this.metaService.updateRoleNames(RoleNamePossibleValuesService.this.previousRoleName, RoleNamePossibleValuesService.this.currentRoleName);
                    RoleNamePossibleValuesService.this.previousRoleName = RoleNamePossibleValuesService.this.currentRoleName;
                }
            }
        };
        this.metaService.attach(this.metaRoleNamesListener);
        this.op().getName().attach(this.roleNameListener);
        super.initPossibleValuesService();
    }

    protected void compute(Set<String> values) {
        String[] stringArray = this.metaService.getRoleNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            values.add(roleName);
            ++n2;
        }
    }

    public void dispose() {
        this.metaService.updateRoleNames(this.previousRoleName, "");
        if (this.op() != null && !this.op().disposed()) {
            this.op().getName().detach(this.roleNameListener);
        }
        this.metaService.detach(this.metaRoleNamesListener);
        this.previousRoleName = null;
        this.currentRoleName = null;
        this.roleNameListener = null;
        this.metaRoleNamesListener = null;
        this.metaService = null;
        super.dispose();
    }

    private void initMetaServiceIfNecessary() {
        AssignableOp assignableOp;
        WorkflowDefinition definition = (WorkflowDefinition)this.op().nearest(WorkflowDefinition.class);
        if (definition != null) {
            this.metaService.initIfNecessary(definition);
        }
        if ((assignableOp = (AssignableOp)this.op().nearest(AssignableOp.class)) != null) {
            this.metaService.initIfNecessary(assignableOp);
        }
    }

    private Role op() {
        return (Role)this.context(Role.class);
    }
}

