/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.model.internal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.internal.Point;
import com.liferay.ide.kaleo.core.model.internal.TransitionMetadataObject;
import com.liferay.ide.kaleo.core.util.KaleoModelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkflowNodeMetadataObject {
    private boolean terminal = false;
    private Point nodeLocation = new Point();
    private List<TransitionMetadataObject> transitionsMetadata = new ArrayList<TransitionMetadataObject>();

    public WorkflowNodeMetadataObject(String contents) {
        if (!CoreUtil.empty((String)contents)) {
            this.initialize(contents);
        }
    }

    public WorkflowNodeMetadataObject() {
    }

    public boolean equals(Object obj) {
        boolean retval = true;
        if (this != obj) {
            if (obj instanceof WorkflowNodeMetadataObject) {
                WorkflowNodeMetadataObject object = (WorkflowNodeMetadataObject)obj;
                if (this.terminal == object.terminal && this.nodeLocation.equals(object.getNodeLocation())) {
                    int i = 0;
                    while (i < this.transitionsMetadata.size()) {
                        if (!this.transitionsMetadata.get(i).equals(object.transitionsMetadata.get(i))) {
                            retval = false;
                        }
                        ++i;
                    }
                } else {
                    retval = false;
                }
            } else {
                retval = false;
            }
        }
        return retval;
    }

    public Point getNodeLocation() {
        return this.nodeLocation;
    }

    public List<TransitionMetadataObject> getTransitionsMetadata() {
        return this.transitionsMetadata;
    }

    private void initialize(String contents) {
        try {
            JSONObject json = new JSONObject(contents);
            if (json.has("terminal")) {
                this.terminal = json.getBoolean("terminal");
            }
            this.nodeLocation = this.jsonPointToPoint(json);
            if (json.has("transitions")) {
                JSONObject jsonTransitions = json.getJSONObject("transitions");
                Iterator transitionNames = jsonTransitions.keys();
                while (transitionNames.hasNext()) {
                    String name = transitionNames.next().toString();
                    if (!jsonTransitions.has(name)) continue;
                    JSONObject jsonTransitionMetadata = jsonTransitions.getJSONObject(name);
                    TransitionMetadataObject transitionMetaObject = new TransitionMetadataObject();
                    transitionMetaObject.setName(name);
                    if (jsonTransitionMetadata.has("xy")) {
                        JSONArray jsonLabelPosition = jsonTransitionMetadata.getJSONArray("xy");
                        transitionMetaObject.setLabelPosition(this.jsonArrayToPoint(jsonLabelPosition));
                    }
                    if (jsonTransitionMetadata.has("bendpoints")) {
                        JSONArray jsonBendpoints = jsonTransitionMetadata.getJSONArray("bendpoints");
                        int i = 0;
                        while (i < jsonBendpoints.length()) {
                            JSONArray xy = jsonBendpoints.optJSONArray(i);
                            if (xy != null) {
                                transitionMetaObject.getBendpoints().add(this.jsonArrayToPoint(xy));
                            }
                            ++i;
                        }
                    }
                    this.transitionsMetadata.add(transitionMetaObject);
                }
            }
        }
        catch (Exception e) {
            KaleoCore.logError("Error loading node metadata object", e);
        }
    }

    private JSONArray pointToJSONPoint(Point point) {
        JSONArray jsonXY = new JSONArray();
        jsonXY.put(point.getX());
        jsonXY.put(point.getY());
        return jsonXY;
    }

    private Point jsonArrayToPoint(JSONArray jsonArray) {
        Point point = KaleoModelUtil.DEFAULT_POINT;
        try {
            if (jsonArray.length() == 2 && !jsonArray.isNull(0) && !jsonArray.isNull(1)) {
                point = new Point(jsonArray.getInt(0), jsonArray.getInt(1));
            }
        }
        catch (JSONException ex) {
            KaleoCore.logError("Invalid JSON syntax", (Exception)((Object)ex));
        }
        return point;
    }

    private Point jsonPointToPoint(JSONObject jsonPoint) throws JSONException {
        if (jsonPoint.has("xy")) {
            JSONArray jsonXY = jsonPoint.getJSONArray("xy");
            return this.jsonArrayToPoint(jsonXY);
        }
        return KaleoModelUtil.DEFAULT_POINT;
    }

    public String toJSONString() throws JSONException {
        JSONObject json = new JSONObject();
        if (this.isTerminal()) {
            json.put("terminal", true);
        }
        if (this.nodeLocation != null) {
            JSONArray jsonXY = this.pointToJSONPoint(this.nodeLocation);
            json.put("xy", (Object)jsonXY);
        }
        if (this.transitionsMetadata.size() > 0) {
            JSONObject jsonTransitions = new JSONObject();
            for (TransitionMetadataObject transitionMetadata : this.transitionsMetadata) {
                String transitionName = transitionMetadata.getName();
                if (CoreUtil.empty((String)transitionName)) continue;
                JSONObject jsonTransitionMetadata = new JSONObject();
                JSONArray jsonBendpoints = new JSONArray();
                for (Point bendpoint : transitionMetadata.getBendpoints()) {
                    JSONArray xy = this.pointToJSONPoint(bendpoint);
                    jsonBendpoints.put((Object)xy);
                }
                Point labelPosition = transitionMetadata.getLabelPosition();
                if (!labelPosition.equals(KaleoModelUtil.DEFAULT_POINT)) {
                    JSONArray xy = this.pointToJSONPoint(labelPosition);
                    jsonTransitionMetadata.put("xy", (Object)xy);
                }
                jsonTransitionMetadata.put("bendpoints", (Object)jsonBendpoints);
                jsonTransitions.put(transitionName, (Object)jsonTransitionMetadata);
            }
            json.put("transitions", (Object)jsonTransitions);
        }
        return json.toString();
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public void setNodeLocation(Point nodeLocation) {
        this.nodeLocation = nodeLocation;
    }
}

