/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.op.internal;

import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.model.Action;
import com.liferay.ide.kaleo.core.model.ExecutionType;
import com.liferay.ide.kaleo.core.model.ScriptLanguageType;
import com.liferay.ide.kaleo.core.model.State;
import com.liferay.ide.kaleo.core.model.Task;
import com.liferay.ide.kaleo.core.model.Transition;
import com.liferay.ide.kaleo.core.model.TransitionMetadata;
import com.liferay.ide.kaleo.core.model.WorkflowDefinition;
import com.liferay.ide.kaleo.core.model.WorkflowNodeMetadata;
import com.liferay.ide.kaleo.core.op.NewWorkflowDefinitionOp;
import com.liferay.ide.kaleo.core.util.KaleoModelUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class NewWorkflowDefinitionOpMethods {
    public static final Status execute(NewWorkflowDefinitionOp op, ProgressMonitor monitor) {
        try {
            IProject project = (IProject)op.getProject().target();
            Path projectPath = (Path)op.getFolder().content();
            Object folder = null;
            folder = projectPath != null ? project.getFolder(projectPath.toPortableString()) : project;
            if (!folder.exists()) {
                folder = folder.getParent();
            }
            String name = (String)op.getName().content();
            String[] segments = name.toLowerCase().split("\\s+");
            StringBuilder newName = new StringBuilder();
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                newName.append(segment).append('-');
                ++n2;
            }
            String fileNameBase = String.valueOf(newName.toString()) + "definition";
            String extension = ".xml";
            String fileName = String.valueOf(fileNameBase) + ".xml";
            IFile newDefinitionFile = project.getFile(folder.getProjectRelativePath().append(fileName));
            int count = 1;
            while (newDefinitionFile.exists()) {
                fileName = String.valueOf(fileNameBase) + " (" + count + ")" + ".xml";
                newDefinitionFile = project.getFile(folder.getProjectRelativePath().append(fileName));
                ++count;
            }
            newDefinitionFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            newDefinitionFile.setPersistentProperty(KaleoCore.DEFAULT_SCRIPT_LANGUAGE_KEY, op.getDefaultScriptLanguage().text(true));
            newDefinitionFile.setPersistentProperty(KaleoCore.DEFAULT_TEMPLATE_LANGUAGE_KEY, op.getDefaultTemplateLanguage().text(true));
            RootXmlResource rootXmlResource = new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(newDefinitionFile)));
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)WorkflowDefinition.TYPE.instantiate((Resource)rootXmlResource);
            workflowDefinition.setName(name);
            workflowDefinition.setVersion("1");
            String initialStateName = (String)op.getInitialStateName().content(true);
            State state = (State)workflowDefinition.getStates().insert();
            state.setName(initialStateName);
            state.setInitial(true);
            String initialTaskName = (String)op.getInitialTaskName().content(true);
            Task task = (Task)workflowDefinition.getTasks().insert();
            task.setName(initialTaskName);
            KaleoModelUtil.changeTaskAssignments(task, op);
            Transition transition = (Transition)state.getTransitions().insert();
            transition.setName(initialTaskName);
            transition.setTarget(initialTaskName);
            String finalStateName = (String)op.getFinalStateName().content(true);
            State finalState = (State)workflowDefinition.getStates().insert();
            finalState.setName(finalStateName);
            finalState.setEnd(true);
            Action finalAction = (Action)finalState.getActions().insert();
            finalAction.setName("approve");
            finalAction.setExecutionType(ExecutionType.ON_ENTRY);
            finalAction.setScriptLanguage(ScriptLanguageType.JAVASCRIPT);
            finalAction.setScript("Packages.com.liferay.portal.kernel.workflow.WorkflowStatusManagerUtil.updateStatus(Packages.com.liferay.portal.kernel.workflow.WorkflowConstants.toStatus(\"approved\"), workflowContext);");
            Transition taskTransition = (Transition)task.getTransitions().insert();
            taskTransition.setName(finalStateName);
            taskTransition.setTarget(finalStateName);
            WorkflowNodeMetadata stateMetadata = (WorkflowNodeMetadata)state.getMetadata().content();
            stateMetadata.getPosition().setX(100);
            stateMetadata.getPosition().setY(50);
            ((TransitionMetadata)stateMetadata.getTransitionsMetadata().insert()).setName(initialTaskName);
            WorkflowNodeMetadata taskMetadata = (WorkflowNodeMetadata)task.getMetadata().content();
            taskMetadata.getPosition().setX(300);
            taskMetadata.getPosition().setY(35);
            ((TransitionMetadata)taskMetadata.getTransitionsMetadata().insert()).setName(finalStateName);
            WorkflowNodeMetadata finalStateMetadata = (WorkflowNodeMetadata)finalState.getMetadata().content();
            finalStateMetadata.getPosition().setX(520);
            finalStateMetadata.getPosition().setY(50);
            rootXmlResource.save();
            op.setNewFilePath(newDefinitionFile.getFullPath().toPortableString());
            return Status.createOkStatus();
        }
        catch (Exception e) {
            KaleoCore.logError("Error creating new kaleo workflow file.", e);
            return Status.createErrorStatus((String)"Error creating new kaleo workflow file.", (Throwable)e);
        }
    }
}

