/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.kaleo.core.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.kaleo.core.KaleoCore;
import com.liferay.ide.kaleo.core.util.IWorkflowValidation;
import com.liferay.ide.project.core.BaseValidator;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class WorkflowDefinitionValidator
extends BaseValidator {
    public static final String MARKER_TYPE = "com.liferay.ide.kaleo.core.workflowDefinitionMarker";
    public static final String PREFERENCE_NODE_QUALIFIER = KaleoCore.getDefault().getBundle().getSymbolicName();
    public static final String WORKFLOW_DEFINITION_VALIDATE = "validation-workflow-definition-validate";

    Map<String, Object>[] detectProblems(IFile workflowDefinitionXml, IScopeContext[] preferenceScopes) throws CoreException {
        ArrayList<Map> problems;
        block11: {
            IStructuredModel model;
            block10: {
                problems = new ArrayList<Map>();
                model = null;
                try {
                    try {
                        model = StructuredModelManager.getModelManager().getModelForRead(workflowDefinitionXml);
                        if (model == null || !(model instanceof IDOMModel)) break block10;
                        IDOMDocument document = ((IDOMModel)model).getDocument();
                        try {
                            IWorkflowValidation workflowValidation = KaleoCore.getWorkflowValidation(ServerUtil.getRuntime((IProject)workflowDefinitionXml.getProject()));
                            Exception error = workflowValidation.validate(workflowDefinitionXml.getContents());
                            if (error != null && !CoreUtil.isNullOrEmpty((String)error.getMessage())) {
                                Map problem = this.createMarkerValues(PREFERENCE_NODE_QUALIFIER, preferenceScopes, WORKFLOW_DEFINITION_VALIDATE, (IDOMNode)document.getFirstChild(), error.getMessage());
                                problems.add(problem);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception document) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    throw throwable;
                }
            }
            if (model != null) {
                model.releaseFromRead();
            }
        }
        Map[] retval = new Map[problems.size()];
        return problems.toArray(retval);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IFile workflowDefinitionXml = (IFile)resource;
        if (workflowDefinitionXml.isAccessible() && CoreUtil.isLiferayProject((IProject)resource.getProject())) {
            IScopeContext[] scopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
            ProjectScope projectScope = new ProjectScope(workflowDefinitionXml.getProject());
            boolean useProjectSettings = projectScope.getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("use-project-settings", false);
            if (useProjectSettings) {
                scopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
            }
            try {
                Map<String, Object>[] problems = this.detectProblems(workflowDefinitionXml, scopes);
                int i = 0;
                while (i < problems.length) {
                    ValidatorMessage message = ValidatorMessage.create((String)problems[i].get("message").toString(), (IResource)resource);
                    message.setType(MARKER_TYPE);
                    message.setAttributes(problems[i]);
                    result.add(message);
                    ++i;
                }
                if (problems.length > 0) {
                    result.setDependsOn(new IResource[]{workflowDefinitionXml});
                }
            }
            catch (Exception e) {
                KaleoCore.logError(e);
            }
        }
        return result;
    }
}

