/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.ui.ImageResource;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.preferences.PropertyPreferencePage;

public class TernContentAssistPreferencesPage
extends PropertyPreferencePage {
    public static final String PROPERTY_PAGE_ID = "tern.eclipse.ide.ui.properties.contentassist";
    public static final String PREFERENCE_PAGE_ID = "tern.eclipse.ide.ui.preferences.contentassist";
    private final IPreferencesService fPreferencesService;
    private Button generateAnonymousFunctionCheckbox;
    private Button expandFunctionCheckbox;
    private Button omitObjectPrototype;
    private Button guess;
    private Text indentSizeText;
    private Button indentTabsButton;

    public TernContentAssistPreferencesPage() {
        this.setImageDescriptor(ImageResource.getImageDescriptor("logo"));
        this.fPreferencesService = Platform.getPreferencesService();
    }

    @Override
    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        IScopeContext[] preferenceScopes = this.createPreferenceScopes();
        this.createInsertionContents(page, preferenceScopes);
        this.createFilteringContents(page, preferenceScopes);
        return page;
    }

    private void createFilteringContents(Composite parent, IScopeContext[] preferenceScopes) {
        Group filteringGroup = new Group(parent, 16);
        filteringGroup.setText(TernUIMessages.TernContentAssistPreferencesPage_filteringGroup_label);
        filteringGroup.setLayout((Layout)new GridLayout());
        filteringGroup.setLayoutData((Object)new GridData(768));
        this.expandFunctionCheckbox = this.createCheckbox((Composite)filteringGroup, "expand-function-contentassist", preferenceScopes, TernUIMessages.TernContentAssistPreferencesPage_expandFunction_label);
        this.omitObjectPrototype = this.createCheckbox((Composite)filteringGroup, "omitObjectPrototype", preferenceScopes, TernUIMessages.TernContentAssistPreferencesPage_omitObjectPrototype_label);
        this.guess = this.createCheckbox((Composite)filteringGroup, "guess", preferenceScopes, TernUIMessages.TernContentAssistPreferencesPage_guess_label);
    }

    private void createInsertionContents(Composite parent, IScopeContext[] preferenceScopes) {
        Group insertionGroup = new Group(parent, 16);
        insertionGroup.setText(TernUIMessages.TernContentAssistPreferencesPage_insertionGroup_label);
        insertionGroup.setLayout((Layout)new GridLayout());
        insertionGroup.setLayoutData((Object)new GridData(768));
        this.createIndentContent((Composite)insertionGroup, preferenceScopes);
        this.createFunctionInsertionContents((Composite)insertionGroup, preferenceScopes);
        this.createObjLitInsertionContents((Composite)insertionGroup, preferenceScopes);
    }

    private void createIndentContent(Composite ancestor, IScopeContext[] preferenceScopes) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(768));
        Label indentLabel = new Label(parent, 0);
        indentLabel.setText(TernUIMessages.TernContentAssistPreferencesPage_indentation_label);
        this.indentSizeText = new Text(parent, 2048);
        this.updateTextInt(this.indentSizeText, "indent-size-contentassist", preferenceScopes);
        Button indentSpacesButton = new Button(parent, 16);
        indentSpacesButton.setText("Spaces");
        this.indentTabsButton = new Button(parent, 16);
        this.indentTabsButton.setText("Tabs");
        this.updateCheckbox(this.indentTabsButton, "indent-tabs-contentassist", preferenceScopes);
        indentSpacesButton.setSelection(!this.indentTabsButton.getSelection());
    }

    private void createFunctionInsertionContents(Composite parent, IScopeContext[] preferenceScopes) {
        Group insertionGroup = new Group(parent, 16);
        insertionGroup.setText(TernUIMessages.TernContentAssistPreferencesPage_functionInsertionGroup_label);
        insertionGroup.setLayout((Layout)new GridLayout());
        insertionGroup.setLayoutData((Object)new GridData(768));
        this.generateAnonymousFunctionCheckbox = this.createCheckbox((Composite)insertionGroup, "generate-anonymous-function-contentassist", preferenceScopes, TernUIMessages.TernContentAssistPreferencesPage_generateAnonymousFunction_label);
    }

    private void createObjLitInsertionContents(Composite parent, IScopeContext[] preferenceScopes) {
        Group insertionGroup = new Group(parent, 16);
        insertionGroup.setText(TernUIMessages.TernContentAssistPreferencesPage_objLitInsertionGroup_label);
        insertionGroup.setLayout((Layout)new GridLayout());
        insertionGroup.setLayoutData((Object)new GridData(768));
    }

    private ComboViewer createComboViewer(Composite ancestor, String preferenceName, IScopeContext[] preferenceScopes, String label) {
        Composite parent = new Composite(ancestor, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(768));
        Label comboLabel = new Label(parent, 0);
        comboLabel.setText(label);
        ComboViewer viewer = new ComboViewer(parent);
        return viewer;
    }

    private Button createCheckbox(Composite parent, String preferenceName, IScopeContext[] preferenceScopes, String label) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(label);
        checkbox.setLayoutData((Object)new GridData(32, 8, false, false, 1, 1));
        this.updateCheckbox(checkbox, preferenceName, preferenceScopes);
        return checkbox;
    }

    private void updateCheckbox(Button checkbox, String preferenceName, IScopeContext[] preferenceScopes) {
        boolean checked = this.fPreferencesService.getBoolean(this.getPreferenceNodeQualifier(), preferenceName, true, preferenceScopes);
        checkbox.setSelection(checked);
    }

    private void updateCheckbox(Button checkbox, String preferenceName, IEclipsePreferences defaultPreferences) {
        boolean checked = defaultPreferences.getBoolean(preferenceName, false);
        checkbox.setSelection(checked);
    }

    private void updateTextInt(Text text, String preferenceName, IScopeContext[] preferenceScopes) {
        int value = this.fPreferencesService.getInt(this.getPreferenceNodeQualifier(), preferenceName, 1, preferenceScopes);
        text.setText(String.valueOf(value));
    }

    private void updateTextAsInt(Text text, String preferenceName, IEclipsePreferences defaultPreferences) {
        int value = defaultPreferences.getInt(preferenceName, 1);
        text.setText(String.valueOf(value));
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        IEclipsePreferences defaultPreferences = this.createPreferenceScopes()[1].getNode(this.getPreferenceNodeQualifier());
        this.updateCheckbox(this.generateAnonymousFunctionCheckbox, "generate-anonymous-function-contentassist", defaultPreferences);
        this.updateTextAsInt(this.indentSizeText, "indent-size-contentassist", defaultPreferences);
        this.updateCheckbox(this.indentTabsButton, "indent-tabs-contentassist", defaultPreferences);
        this.updateCheckbox(this.expandFunctionCheckbox, "expand-function-contentassist", defaultPreferences);
        this.updateCheckbox(this.omitObjectPrototype, "omitObjectPrototype", defaultPreferences);
        this.updateCheckbox(this.guess, "guess", defaultPreferences);
    }

    @Override
    public boolean performOk() {
        boolean ok = super.performOk();
        IScopeContext[] contexts = this.createPreferenceScopes();
        boolean remove = this.getProject() != null && !this.isElementSettingsEnabled();
        this.updateContexts(this.generateAnonymousFunctionCheckbox, "generate-anonymous-function-contentassist", contexts, remove);
        this.updateContextsAsInt(this.indentSizeText, "indent-size-contentassist", contexts, remove);
        this.updateContexts(this.indentTabsButton, "indent-tabs-contentassist", contexts, remove);
        this.updateContexts(this.expandFunctionCheckbox, "expand-function-contentassist", contexts, remove);
        this.updateContexts(this.omitObjectPrototype, "omitObjectPrototype", contexts, remove);
        this.updateContexts(this.guess, "guess", contexts, remove);
        this.flushContexts(contexts);
        return ok;
    }

    private void updateContexts(Button checkbox, String preferenceName, IScopeContext[] contexts, boolean remove) {
        if (remove) {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove(preferenceName);
        } else {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean(preferenceName, checkbox.getSelection());
        }
    }

    private void updateContextsAsInt(Text text, String preferenceName, IScopeContext[] contexts, boolean remove) {
        if (remove) {
            contexts[0].getNode(this.getPreferenceNodeQualifier()).remove(preferenceName);
        } else {
            try {
                contexts[0].getNode(this.getPreferenceNodeQualifier()).putInt(preferenceName, Integer.parseInt(text.getText()));
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected String getPreferenceNodeQualifier() {
        return TernUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    @Override
    protected String getPreferencePageID() {
        return PREFERENCE_PAGE_ID;
    }

    @Override
    protected String getProjectSettingsKey() {
        return "contentassist-use-project-settings";
    }

    @Override
    protected String getPropertyPageID() {
        return PROPERTY_PAGE_ID;
    }

    public void init(IWorkbench workbencsh) {
    }
}

