/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.hyperlink;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.hyperlink.TernHyperlink;
import tern.eclipse.ide.ui.JavaWordFinder;
import tern.eclipse.ide.ui.utils.EditorUtils;

public class TernHyperLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IResource resource = this.getResource(textViewer);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (TernCorePlugin.hasTernNature((IProject)project)) {
            try {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)project);
                IDocument document = textViewer.getDocument();
                IRegion wordRegion = JavaWordFinder.findWord(document, region.getOffset());
                TernHyperlink hyperlink = new TernHyperlink(document, wordRegion, resource, ternProject);
                if (hyperlink.isValid()) {
                    IHyperlink[] hyperlinks = new IHyperlink[]{hyperlink};
                    return hyperlinks;
                }
                return null;
            }
            catch (CoreException e) {
                Trace.trace((byte)2, "Error while tern hyperlink", e);
            }
        }
        return null;
    }

    protected IResource getResource(ITextViewer textViewer) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (textEditor != null) {
            return EditorUtils.getResource((IEditorPart)textEditor);
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(textViewer.getDocument());
        if (textFileBuffer != null) {
            IPath location = textFileBuffer.getLocation();
            return ResourcesPlugin.getWorkspace().getRoot().findMember(location);
        }
        return null;
    }
}

