/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.blade.gradle.model.CustomModel;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.LiferayNature;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.GradleTooling;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.osgi.framework.BundleContext;

public class GradleCore
extends Plugin {
    private static GradleCore plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.gradle.core";
    public static final String JobFamilyId = "CheckingGradleConfiguration";
    public static final File customModelCache;

    static {
        customModelCache = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
    }

    public static IStatus createErrorStatus(Exception ex) {
        return new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createWarningStatus(String msg) {
        return new Status(2, PLUGIN_ID, msg);
    }

    public static GradleCore getDefault() {
        return plugin;
    }

    public static <T> T getToolingModel(GradleCore gradleCore, Class<T> modelClass, File projectDir) {
        T retval = null;
        try {
            retval = GradleTooling.getModel(modelClass, customModelCache, projectDir);
        }
        catch (Exception e) {
            GradleCore.logError("Error getting tooling model", e);
        }
        return retval;
    }

    public static <T> T getToolingModel(GradleCore gradleCore, Class<T> modelClass, IProject gradleProject) {
        return GradleCore.getToolingModel(gradleCore, modelClass, gradleProject.getLocation().toFile());
    }

    public static void logError(Exception ex) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(ex));
    }

    public static void logError(String msg) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg));
    }

    public static void logError(String msg, Exception e) {
        GradleCore.getDefault().getLog().log(GradleCore.createErrorStatus(msg, e));
    }

    private static void configureIfLiferayProject(final IProject project, final GradleCore gradleCore) throws CoreException {
        if (project.hasNature("org.eclipse.buildship.core.gradleprojectnature") && !LiferayNature.hasNature((IProject)project)) {
            final boolean[] needAddNature = new boolean[]{false};
            IFile bndFile = project.getFile("bnd.bnd");
            if (bndFile != null && bndFile.exists()) {
                needAddNature[0] = true;
            } else if (ProjectUtil.isWorkspaceWars((IProject)project)) {
                needAddNature[0] = true;
            } else {
                IFile gulpFile = project.getFile("gulpfile.js");
                if (gulpFile != null && gulpFile.exists()) {
                    try {
                        String gulpFileContent = new String(Files.readAllBytes(gulpFile.getLocation().toFile().toPath()), StandardCharsets.UTF_8);
                        if (gulpFileContent.contains("require('liferay-theme-tasks')")) {
                            needAddNature[0] = true;
                        }
                    }
                    catch (IOException e) {
                        GradleCore.logError("read gulpfile.js file fail", e);
                    }
                }
            }
            WorkspaceJob job = new WorkspaceJob("Checking gradle configuration"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        if (needAddNature[0]) {
                            LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)monitor);
                            return Status.OK_STATUS;
                        }
                        CustomModel customModel = GradleCore.getToolingModel(gradleCore, CustomModel.class, project);
                        if (customModel == null) {
                            throw new CoreException(GradleCore.createErrorStatus("Unable to get read gradle configuration"));
                        }
                        if (customModel.isLiferayModule() || customModel.hasPlugin("org.gradle.api.plugins.WarPlugin") || customModel.hasPlugin("com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin")) {
                            LiferayNature.addLiferayNature((IProject)project, (IProgressMonitor)monitor);
                        }
                    }
                    catch (Exception e) {
                        GradleCore.logError("Unable to get tooling model", e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family != null && family.toString().equals(GradleCore.JobFamilyId);
                }
            };
            job.setRule((ISchedulingRule)CoreUtil.getWorkspaceRoot());
            job.schedule();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CoreUtil.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            try {
                                IProjectDescription projectDescription;
                                String projectName;
                                IProject project;
                                IResource resource = delta.getResource();
                                if (delta.getKind() == 1 && resource.getLocation().toFile().exists() && resource.getName().equals(".project") && (project = CoreUtil.getProject((String)(projectName = (projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(resource.getLocation())).getName()))) != null && project.isAccessible()) {
                                    GradleCore.configureIfLiferayProject(CoreUtil.getProject((String)projectName), GradleCore.this);
                                }
                            }
                            catch (Exception e) {
                                GradleCore.logError(e);
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    GradleCore.logError((Exception)((Object)e));
                }
            }
        }, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

