/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.Platform;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.osgi.framework.Bundle;

public class GradleTooling {
    private static void extractJar(File depsDir, String jarName) throws IOException {
        InputStream in = GradleTooling.class.getResourceAsStream("/lib/" + jarName + ".jar");
        Bundle bundle = Platform.getBundle((String)"com.liferay.ide.gradle.core");
        String bundleVersion = bundle.getVersion().toString();
        File modelJar = new File(depsDir, String.valueOf(jarName) + "_" + bundleVersion + ".jar");
        if (!modelJar.exists()) {
            FileUtil.writeFileFromStream((File)modelJar, (InputStream)in);
        }
    }

    public static <T> T getModel(Class<T> modelClass, File cacheDir, File projectDir) throws Exception {
        Object retval = null;
        GradleConnector connector = GradleConnector.newConnector().forProjectDirectory(projectDir);
        try (ProjectConnection connection = null;){
            connection = connector.connect();
            ModelBuilder modelBuilder = connection.model(modelClass);
            File depsDir = new File(cacheDir, "deps");
            depsDir.mkdirs();
            String path = depsDir.getAbsolutePath();
            path = path.replaceAll("\\\\", "/");
            GradleTooling.extractJar(depsDir, "com.liferay.blade.gradle.model");
            GradleTooling.extractJar(depsDir, "com.liferay.blade.gradle.plugin");
            String initScriptTemplate = CoreUtil.readStreamToString((InputStream)GradleTooling.class.getResourceAsStream("init.gradle"));
            String initScriptContents = initScriptTemplate.replaceFirst("%deps%", path);
            File scriptFile = Files.createTempFile("ide", "init.gradle", new FileAttribute[0]).toFile();
            FileUtil.writeFileFromStream((File)scriptFile, (InputStream)new ByteArrayInputStream(initScriptContents.getBytes()));
            retval = ((ModelBuilder)modelBuilder.withArguments(new String[]{"--init-script", scriptFile.getAbsolutePath()})).get();
        }
        return (T)retval;
    }
}

