/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core;

import com.liferay.ide.core.AbstractLiferayProjectProvider;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.gradle.core.GradleCore;
import com.liferay.ide.gradle.core.GradleUtil;
import com.liferay.ide.gradle.core.LiferayWorkspaceProject;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.BladeCLIException;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceOp;
import com.liferay.ide.project.core.workspace.NewLiferayWorkspaceProjectProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.platform.PathBridge;

public class LiferayGradleWorkspaceProjectProvider
extends AbstractLiferayProjectProvider
implements NewLiferayWorkspaceProjectProvider<NewLiferayWorkspaceOp> {
    public LiferayGradleWorkspaceProjectProvider() {
        super(new Class[]{IProject.class});
    }

    public IStatus createNewProject(NewLiferayWorkspaceOp op, IProgressMonitor monitor) throws CoreException {
        IPath location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)op.getLocation().content()));
        String wsName = op.getWorkspaceName().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("-b ");
        sb.append("\"" + location.append(wsName).toFile().getAbsolutePath() + "\"");
        sb.append(" ");
        sb.append("init");
        try {
            BladeCLI.execute((String)sb.toString());
        }
        catch (BladeCLIException e) {
            return ProjectCore.createErrorStatus((Exception)((Object)e));
        }
        String workspaceLocation = location.append(wsName).toPortableString();
        boolean isInitBundle = (Boolean)op.getProvisionLiferayBundle().content();
        String bundleUrl = (String)op.getBundleUrl().content(false);
        return this.importProject(workspaceLocation, monitor, isInitBundle, bundleUrl);
    }

    public IStatus importProject(String location, IProgressMonitor monitor, boolean initBundle, String bundleUrl) {
        try {
            IStatus importJob = GradleUtil.importGradleProject(new File(location), monitor);
            if (!importJob.isOK() || importJob.getException() != null) {
                return importJob;
            }
            if (initBundle) {
                Path path = new Path(location);
                path.lastSegment();
                IProject project = CoreUtil.getProject((String)path.lastSegment());
                if (bundleUrl != null) {
                    IFile gradlePropertiesFile = project.getFile("gradle.properties");
                    String content = FileUtil.readContents((InputStream)gradlePropertiesFile.getContents());
                    String bundleUrlProp = "liferay.workspace.bundle.url=" + bundleUrl;
                    String separator = System.getProperty("line.separator", "\n");
                    String newContent = String.valueOf(content) + separator + bundleUrlProp;
                    gradlePropertiesFile.setContents((InputStream)new ByteArrayInputStream(newContent.getBytes()), 1, monitor);
                }
                GradleUtil.runGradleTask(project, "initBundle", monitor);
                project.refreshLocal(2, monitor);
            }
        }
        catch (Exception e) {
            return GradleCore.createErrorStatus("import Liferay workspace project error", e);
        }
        return Status.OK_STATUS;
    }

    public synchronized ILiferayProject provide(Object adaptable) {
        IProject project;
        ILiferayProject retval = null;
        if (adaptable instanceof IProject && LiferayWorkspaceUtil.isValidWorkspace((IProject)(project = (IProject)adaptable))) {
            return new LiferayWorkspaceProject(project);
        }
        return retval;
    }

    public IStatus validateProjectLocation(String projectName, IPath path) {
        IStatus retval = Status.OK_STATUS;
        return retval;
    }
}

