/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.parser;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.parser.FindDependenciesVisitor;
import com.liferay.ide.gradle.core.parser.GradleDependency;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;

public class GradleDependencyUpdater {
    private List<ASTNode> nodes;
    private File file;
    private List<String> gradleFileContents;

    public GradleDependencyUpdater(File inputfile) throws MultipleCompilationErrorsException, IOException {
        this(IOUtils.toString((InputStream)new FileInputStream(inputfile), (String)"UTF-8"));
        this.file = inputfile;
    }

    public GradleDependencyUpdater(String scriptContents) throws MultipleCompilationErrorsException {
        AstBuilder builder = new AstBuilder();
        this.nodes = builder.buildFromString(scriptContents);
    }

    public FindDependenciesVisitor insertDependency(GradleDependency gradleDependency) throws IOException {
        String dependency = "compile group: \"" + gradleDependency.getGroup() + "\", name:\"" + gradleDependency.getName() + "\", version:\"" + gradleDependency.getVersion() + "\"";
        return this.insertDependency(dependency);
    }

    public FindDependenciesVisitor insertDependency(String dependency) throws IOException {
        FindDependenciesVisitor visitor = new FindDependenciesVisitor();
        this.walkScript((GroovyCodeVisitor)visitor);
        this.gradleFileContents = FileUtils.readLines((File)this.file);
        if (!dependency.startsWith("\t")) {
            dependency = "\t" + dependency;
        }
        if (visitor.getDependenceLineNum() == -1) {
            this.gradleFileContents.add("");
            this.gradleFileContents.add("dependencies {");
            this.gradleFileContents.add(dependency);
            this.gradleFileContents.add("}");
        } else if (visitor.getColumnNum() != -1) {
            this.gradleFileContents = Files.readAllLines(Paths.get(this.file.toURI()), StandardCharsets.UTF_8);
            StringBuilder builder = new StringBuilder(this.gradleFileContents.get(visitor.getDependenceLineNum() - 1));
            builder.insert(visitor.getColumnNum() - 2, "\n" + dependency + "\n");
            String dep = builder.toString();
            if (CoreUtil.isWindows()) {
                dep.replace("\n", "\r\n");
            } else if (CoreUtil.isMac()) {
                dep.replace("\n", "\r");
            }
            this.gradleFileContents.remove(visitor.getDependenceLineNum() - 1);
            this.gradleFileContents.add(visitor.getDependenceLineNum() - 1, dep);
        } else {
            this.gradleFileContents.add(visitor.getDependenceLineNum() - 1, dependency);
        }
        return visitor;
    }

    public List<GradleDependency> getAllDependencies() {
        FindDependenciesVisitor visitor = new FindDependenciesVisitor();
        this.walkScript((GroovyCodeVisitor)visitor);
        return visitor.getDependencies();
    }

    public void walkScript(GroovyCodeVisitor visitor) {
        for (ASTNode node : this.nodes) {
            node.visit(visitor);
        }
    }

    public List<String> getGradleFileContents() {
        return this.gradleFileContents;
    }
}

