/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.wst.jsdt.core.dom.BindingResolverDom;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnitResolver;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.core.BasicCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.RecordedParsingInformation;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.esprima.EsprimaParser;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private boolean statementsRecovery;
    private boolean bindingsRecovery;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ITypeRoot typeRoot = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaScriptProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.typeRoot = null;
        this.resolveBindings = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        Hashtable options = JavaScriptCore.getOptions();
        options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setBindingsRecovery(boolean enabled) {
        this.bindingsRecovery = enabled;
    }

    public void setCompilerOptions(Map options) {
        options = options == null ? JavaScriptCore.getOptions() : new HashMap(options);
        options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean bindings) {
        this.resolveBindings = bindings;
    }

    public void setFocalPosition(int position) {
        this.partial = true;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.typeRoot = null;
    }

    public void setSource(IJavaScriptUnit source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(IClassFile source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(ITypeRoot source) {
        this.typeRoot = source;
        this.rawSource = null;
        if (source != null) {
            this.project = source.getJavaScriptProject();
            Map options = this.project.getOptions(true);
            options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setStatementsRecovery(boolean enabled) {
        this.statementsRecovery = enabled;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaScriptProject project) {
        this.project = project;
        if (project != null) {
            Map options = project.getOptions(true);
            options.remove("org.eclipse.wst.jsdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public ASTNode createAST(IProgressMonitor monitor) {
        ASTNode result = null;
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            if (this.rawSource == null && this.typeRoot == null) {
                throw new IllegalStateException("source not specified");
            }
            if (this.typeRoot instanceof IJavaScriptUnit) {
                String sourceType = this.project.getOption("org.eclipse.wst.jsdt.core.compiler.source.type", true);
                JavaScriptUnit unit = EsprimaParser.newParser().includeComments().setSourceType(sourceType).setSource((IJavaScriptUnit)this.typeRoot).parse();
                unit.setTypeRoot(this.typeRoot);
                result = unit;
                if (this.resolveBindings) {
                    this.resolveBindings(unit);
                }
                unit.ast.setOriginalModificationCount(unit.ast.modificationCount());
                Scanner scanner = new Scanner(true, false, false, 3L, null, null, true);
                try {
                    scanner.setSource(this.typeRoot.getSource().toCharArray());
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            } else {
                result = this.internalCreateAST(monitor);
            }
        }
        finally {
            this.initializeDefaults();
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    public void createASTs(IJavaScriptUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                if (this.bindingsRecovery) {
                    flags |= 4;
                }
                JavaScriptUnitResolver.resolve(compilationUnits, bindingKeys, requestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            } else {
                JavaScriptUnitResolver.parse(compilationUnits, requestor, this.apiLevel, this.compilerOptions, flags, monitor);
            }
        }
        finally {
            this.initializeDefaults();
        }
    }

    public IBinding[] createBindings(IJavaScriptElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.bindingsRecovery) {
                flags |= 4;
            }
            IBinding[] iBindingArray = JavaScriptUnitResolver.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            return iBindingArray;
        }
        finally {
            this.initializeDefaults();
        }
    }

    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        boolean needToResolveBindings = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    BasicCompilationUnit sourceUnit = null;
                    Scanner scanner = new Scanner(true, false, false, 3L, null, null, true);
                    if (this.typeRoot instanceof IJavaScriptUnit) {
                        JavaScriptUnit result = EsprimaParser.newParser().includeComments().setSourceType(this.project.getOption("org.eclipse.wst.jsdt.core.compiler.source.type", true)).setSource((IJavaScriptUnit)this.typeRoot).parse();
                        result.setTypeRoot(this.typeRoot);
                        result.ast.setOriginalModificationCount(result.ast.modificationCount());
                        try {
                            scanner.setSource(this.typeRoot.getSource().toCharArray());
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                        if (needToResolveBindings) {
                            this.resolveBindings(result);
                        }
                        JavaScriptUnit javaScriptUnit = result;
                        return javaScriptUnit;
                    }
                    if (this.typeRoot instanceof IClassFile) {
                        try {
                            String sourceString = this.typeRoot.getSource();
                            if (sourceString == null) {
                                throw new IllegalStateException();
                            }
                            PackageFragment packageFragment = (PackageFragment)this.typeRoot.getParent();
                            char[] fileName = this.typeRoot.getElementName().toCharArray();
                            sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), new String(fileName), this.project);
                        }
                        catch (JavaScriptModelException javaScriptModelException) {
                            throw new IllegalStateException();
                        }
                    } else if (this.rawSource != null) {
                        needToResolveBindings = this.resolveBindings && this.unitName != null && this.project != null && this.compilerOptions != null;
                        sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    } else {
                        throw new IllegalStateException();
                    }
                    String sourceType = this.project != null ? this.project.getOption("org.eclipse.wst.jsdt.core.compiler.source.type", true) : null;
                    JavaScriptUnit $ = EsprimaParser.newParser().setSourceType(sourceType).setSource(String.valueOf(sourceUnit.getContents())).parse();
                    $.setTypeRoot(this.typeRoot);
                    $.ast.setOriginalModificationCount($.ast.modificationCount());
                    scanner.setSource(sourceUnit.getContents());
                    $.initCommentMapper(scanner);
                    if (needToResolveBindings) {
                        this.resolveBindings($);
                    }
                    JavaScriptUnit javaScriptUnit = $;
                    return javaScriptUnit;
                }
                finally {
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                        if (compilationUnitDeclaration.scope != null) {
                            compilationUnitDeclaration.scope.cleanup();
                        }
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        char[] contentArray = new char[this.sourceLength];
        System.arraycopy(this.rawSource, this.sourceOffset, contentArray, 0, this.sourceLength);
        JavaScriptUnit unit = EsprimaParser.newParser().includeComments().setSourceType(this.project.getOption("org.eclipse.wst.jsdt.core.compiler.source.type", true)).setSource(String.valueOf(contentArray)).parse();
        unit.ast.setOriginalModificationCount(unit.ast.modificationCount());
        Scanner scanner = new Scanner(true, false, false, 3L, null, null, true);
        scanner.setSource(this.rawSource);
        unit.initCommentMapper(scanner);
        return unit;
    }

    private void propagateErrors(ASTNode astNode, CategorizedProblem[] problems, RecoveryScannerData data) {
        astNode.accept(new ASTSyntaxErrorPropagator(problems));
        if (data != null) {
            astNode.accept(new ASTRecoveryPropagator(problems, data));
        }
    }

    private void rootNodeToCompilationUnit(AST ast, JavaScriptUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation, RecoveryScannerData data) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(block, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 15: {
                JavaScriptUnit compUnit = (JavaScriptUnit)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = compUnit.statements().size();
                    while (i < max) {
                        this.propagateErrors(compUnit.statements().get(i), (CategorizedProblem[])problems, data);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                if (compilationUnit == node) break;
                int i = 0;
                int max = compUnit.statements().size();
                while (i < max) {
                    compilationUnit.statements().add(compUnit.statements().get(i));
                    ++i;
                }
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(typeDeclaration, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }

    private void resolveBindings(JavaScriptUnit jsunit) {
        BindingResolverDom resolver = new BindingResolverDom(jsunit);
        resolver.resolve();
        AST ast = jsunit.getAST();
        ast.setBindingResolver(resolver);
        ast.setFlag(Integer.MIN_VALUE);
    }
}

