/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;

public class SimpleName
extends Name {
    public static final SimplePropertyDescriptor IDENTIFIER_PROPERTY = new SimplePropertyDescriptor(SimpleName.class, "identifier", String.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final String MISSING_IDENTIFIER = "MISSING";
    private String identifier = "MISSING";

    static {
        ArrayList propertyList = new ArrayList(2);
        SimpleName.createPropertyList(SimpleName.class, propertyList);
        SimpleName.addProperty(IDENTIFIER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SimpleName.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    SimpleName(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SimpleName.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == IDENTIFIER_PROPERTY) {
            if (get) {
                return this.getIdentifier();
            }
            this.setIdentifier((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 42;
    }

    @Override
    ASTNode clone0(AST target) {
        SimpleName result = new SimpleName(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setIdentifier(this.getIdentifier());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(IDENTIFIER_PROPERTY);
        this.identifier = identifier;
        this.postValueChange(IDENTIFIER_PROPERTY);
    }

    void internalSetIdentifier(String ident) {
        this.preValueChange(IDENTIFIER_PROPERTY);
        this.identifier = ident;
        this.postValueChange(IDENTIFIER_PROPERTY);
    }

    public boolean isDeclaration() {
        StructuralPropertyDescriptor d = this.getLocationInParent();
        if (d == null) {
            return false;
        }
        ASTNode parent = this.getParent();
        if (parent instanceof TypeDeclaration) {
            return d == TypeDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof FunctionDeclaration) {
            FunctionDeclaration p = (FunctionDeclaration)parent;
            return !p.isConstructor() && d == FunctionDeclaration.NAME_PROPERTY;
        }
        if (parent instanceof SingleVariableDeclaration) {
            return d == SingleVariableDeclaration.PATTERN_PROPERTY;
        }
        if (parent instanceof VariableDeclarationFragment) {
            return d == VariableDeclarationFragment.NAME_PROPERTY;
        }
        return false;
    }

    @Override
    void appendName(StringBuffer buffer) {
        buffer.append(this.getIdentifier());
    }

    @Override
    int memSize() {
        int size = 52;
        if (this.identifier != MISSING_IDENTIFIER) {
            size += SimpleName.stringSize(this.identifier);
        }
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

