/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import com.google.common.base.Preconditions;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.mylyn.internal.wikitext.html.core.BlockSeparator;
import org.eclipse.mylyn.internal.wikitext.html.core.BlockStrategies;
import org.eclipse.mylyn.internal.wikitext.html.core.BlockStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanStrategies;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanStrategy;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentHandler;

public class HtmlSubsetDocumentBuilder
extends DocumentBuilder {
    private final HtmlDocumentBuilder delegate;
    private BlockStrategies blockStrategies;
    private SpanStrategies spanStrategies;
    private final Stack<BlockStrategy> blockStrategyState = new Stack();
    private final Stack<SpanStrategy> spanStrategyState = new Stack();
    private final Stack<Integer> headingState = new Stack();
    private int supportedHeadingLevel;
    private boolean implicitBlock;
    private BlockSeparator blockSeparator;

    public HtmlSubsetDocumentBuilder(Writer out, boolean formatting) {
        this(new HtmlDocumentBuilder((Writer)Preconditions.checkNotNull((Object)out, (Object)"Must provide a writer"), formatting));
    }

    HtmlSubsetDocumentBuilder(HtmlDocumentBuilder delegate) {
        this.delegate = (HtmlDocumentBuilder)Preconditions.checkNotNull((Object)delegate, (Object)"Must provide a delegate");
    }

    void setSupportedBlockTypes(Set<DocumentBuilder.BlockType> blockTypes) {
        Preconditions.checkState((boolean)this.blockStrategyState.isEmpty());
        this.blockStrategies = new BlockStrategies(blockTypes);
    }

    void setSupportedSpanTypes(Set<DocumentBuilder.SpanType> spanTypes, List<SpanHtmlElementStrategy> spanElementStrategies) {
        Preconditions.checkState((boolean)this.spanStrategyState.isEmpty());
        this.spanStrategies = new SpanStrategies(spanTypes, spanElementStrategies);
    }

    public void setElementNameOfSpanType(DocumentBuilder.SpanType spanType, String elementName) {
        this.delegate.setElementNameOfSpanType(spanType, elementName);
    }

    void setSupportedHeadingLevel(int headingLevel) {
        this.supportedHeadingLevel = headingLevel;
    }

    void setDocumentHandler(HtmlDocumentHandler documentHandler) {
        this.delegate.setDocumentHandler(documentHandler);
    }

    public void beginDocument() {
        this.delegate.beginDocument();
    }

    public void endDocument() {
        this.flush();
        this.delegate.endDocument();
    }

    public void flush() {
        this.assertCloseImplicitBlock();
        this.delegate.flush();
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.assertCloseImplicitBlock();
        this.emitBlockSeparator();
        this.pushBlockStrategy(type, attributes).beginBlock((DocumentBuilder)this.delegate, type, attributes);
    }

    BlockStrategy pushBlockStrategy(DocumentBuilder.BlockType type, Attributes attributes) {
        BlockStrategy strategy = (BlockStrategy)this.blockStrategies.getStrategy(type, attributes);
        this.blockStrategyState.push(strategy);
        return strategy;
    }

    public void endBlock() {
        BlockStrategy blockStrategy = this.blockStrategyState.pop();
        blockStrategy.endBlock((DocumentBuilder)this.delegate);
        this.blockSeparator = blockStrategy.trailingSeparator();
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.assertOpenBlock();
        SpanStrategy strategy = this.pushSpanStrategy(type, attributes);
        strategy.beginSpan((DocumentBuilder)this.delegate, type, attributes);
    }

    SpanStrategy pushSpanStrategy(DocumentBuilder.SpanType type, Attributes attributes) {
        SpanStrategy strategy = this.spanStrategies.getStrategy(type, attributes);
        this.spanStrategyState.push(strategy);
        return strategy;
    }

    public void endSpan() {
        this.spanStrategyState.pop().endSpan((DocumentBuilder)this.delegate);
    }

    public void beginHeading(int level, Attributes attributes) {
        this.assertCloseImplicitBlock();
        this.emitBlockSeparator();
        this.headingState.push(level);
        if (this.headingLevelSupported(level)) {
            this.delegate.beginHeading(level, attributes);
        } else {
            this.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
            this.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
        }
    }

    private void emitBlockSeparator() {
        if (this.blockSeparator != null) {
            this.blockSeparator.emit((DocumentBuilder)this.delegate);
            this.blockSeparator = null;
        }
    }

    boolean headingLevelSupported(int level) {
        return this.supportedHeadingLevel > 0 && level <= this.supportedHeadingLevel;
    }

    public void endHeading() {
        Integer level = this.headingState.pop();
        if (this.headingLevelSupported(level)) {
            this.delegate.endHeading();
        } else {
            this.endSpan();
            this.endBlock();
        }
    }

    public void characters(String text) {
        this.assertOpenBlock();
        this.delegate.characters(text);
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        this.delegate.entityReference(entity);
    }

    public void image(Attributes attributes, String url) {
        this.assertOpenBlock();
        this.delegate.image(attributes, url);
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        this.delegate.link(attributes, hrefOrHashName, text);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.assertOpenBlock();
        this.delegate.imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    public void acronym(String text, String definition) {
        this.assertOpenBlock();
        this.delegate.acronym(text, definition);
    }

    public void lineBreak() {
        this.assertOpenBlock();
        this.delegate.lineBreak();
    }

    public void charactersUnescaped(String literal) {
        this.delegate.charactersUnescaped(literal);
    }

    public void horizontalRule() {
        this.delegate.horizontalRule();
    }

    void setXhtmlStrict(boolean xhtmlStrict) {
        this.delegate.setXhtmlStrict(xhtmlStrict);
    }

    private void assertOpenBlock() {
        if (this.blockStrategyState.isEmpty() && this.headingState.isEmpty()) {
            this.emitBlockSeparator();
            if (this.delegate.isXhtmlStrict()) {
                this.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
                this.implicitBlock = true;
            }
        }
    }

    private void assertCloseImplicitBlock() {
        if (this.implicitBlock) {
            this.endBlock();
            this.implicitBlock = false;
        }
    }

    HtmlDocumentBuilder getDelegate() {
        return this.delegate;
    }
}

