/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.ui.editor.BasicJavaElementHyperlink;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.w3c.dom.Node;

public class PortletURLHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IFile lastFile;
    private long lastModStamp;
    private IRegion lastNodeRegion;
    private IMethod[] lastActionUrlMethods;

    private static boolean isActionMethod(IMethod method) {
        String[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 2 && paramTypes[0].toLowerCase().contains("request") && paramTypes[1].toLowerCase().contains("response");
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] retval = null;
        if (this.shouldDetectHyperlinks(textViewer, region)) {
            Node name;
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            IDOMNode currentNode = DOMUtils.getNodeByOffset((IDocument)document, (int)offset);
            Region nodeRegion = new Region(currentNode.getStartOffset(), currentNode.getEndOffset() - currentNode.getStartOffset());
            if (this.isActionURL((Node)currentNode) && (name = currentNode.getAttributes().getNamedItem("name")) != null) {
                long modStamp = ((IDocumentExtension4)document).getModificationStamp();
                IFile file = DOMUtils.getFile((IDocument)document);
                Object[] actionUrlMethods = null;
                if (file.equals((Object)this.lastFile) && modStamp == this.lastModStamp && nodeRegion.equals(this.lastNodeRegion)) {
                    actionUrlMethods = this.lastActionUrlMethods;
                } else {
                    String nameValue = name.getNodeValue();
                    actionUrlMethods = this.findPortletMethods(document, nameValue);
                    this.lastModStamp = modStamp;
                    this.lastFile = file;
                    this.lastNodeRegion = nodeRegion;
                    this.lastActionUrlMethods = actionUrlMethods;
                }
                if (!CoreUtil.isNullOrEmpty((Object[])actionUrlMethods)) {
                    ArrayList<BasicJavaElementHyperlink> links = new ArrayList<BasicJavaElementHyperlink>();
                    Object[] objectArray = actionUrlMethods;
                    int n = actionUrlMethods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object method = objectArray[n2];
                        if (method.exists()) {
                            links.add(new BasicJavaElementHyperlink((IRegion)nodeRegion, (IJavaElement)method));
                        }
                        ++n2;
                    }
                    if (links.size() != 0) {
                        retval = canShowMultipleHyperlinks ? links.toArray(new IHyperlink[0]) : new IHyperlink[]{(IHyperlink)links.get(0)};
                    }
                }
            }
        }
        return retval;
    }

    private IMethod[] findPortletMethods(IDocument document, String nameValue) {
        IJavaProject project;
        IMethod[] retval = null;
        IFile file = DOMUtils.getFile((IDocument)document);
        if (file != null && file.exists() && (project = JavaCore.create((IProject)file.getProject())) != null && project.exists()) {
            try {
                IType portlet = project.findType("javax.portlet.Portlet");
                if (portlet != null) {
                    ArrayList<IMethod> methods = new ArrayList<IMethod>();
                    ActionMethodCollector requestor = new ActionMethodCollector(methods);
                    IJavaSearchScope scope = SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)portlet, (boolean)true, (boolean)false, null);
                    SearchPattern search = SearchPattern.createPattern((String)nameValue, (int)1, (int)0, (int)8);
                    new SearchEngine().search(search, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                    retval = methods.toArray(new IMethod[0]);
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return retval;
    }

    private boolean isActionURL(Node currentNode) {
        return currentNode != null && currentNode.getNodeName() != null && currentNode.getNodeType() == 1 && currentNode.getNodeName().endsWith("actionURL");
    }

    private boolean shouldDetectHyperlinks(ITextViewer textViewer, IRegion region) {
        return region != null && textViewer != null;
    }

    private static class ActionMethodCollector
    extends SearchRequestor {
        private final List<IMethod> results;

        public ActionMethodCollector(List<IMethod> results) {
            this.results = results;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (element instanceof IMethod && PortletURLHyperlinkDetector.isActionMethod((IMethod)element)) {
                this.results.add((IMethod)element);
            }
        }
    }
}

