/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.wizard;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.PortletCore;
import com.liferay.ide.portlet.core.operation.INewPortletClassDataModelProperties;
import com.liferay.ide.portlet.core.operation.NewEntryClassOperation;
import com.liferay.ide.portlet.core.operation.NewPortletClassOperation;
import com.liferay.ide.project.core.IPluginWizardFragmentProperties;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.descriptor.AddNewPortletOperation;
import com.liferay.ide.project.core.descriptor.RemoveAllPortletsOperation;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.common.operations.AddJavaEEArtifactOperation;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaEEArtifactClassOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AddPortletOperation
extends AddJavaEEArtifactOperation
implements INewPortletClassDataModelProperties,
IPluginWizardFragmentProperties {
    protected IFolder webappRoot;
    protected TemplateContextType portletContextType;
    protected TemplateStore templateStore;

    public AddPortletOperation(IDataModel dataModel, TemplateStore store, TemplateContextType type) {
        super(dataModel);
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.getTargetProject());
        if (webproject != null) {
            this.webappRoot = webproject.getDefaultDocrootFolder();
        }
        this.templateStore = store;
        this.portletContextType = type;
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.CREATE_NEW_PORTLET_CLASS")) {
            status = super.doExecute(monitor, info);
        }
        if (!status.isOK()) {
            return status;
        }
        if (this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE")) {
            try {
                this.createEmptyFileInDefaultSourceFolder(this.getDataModel().getStringProperty("INewPortletClassDataModelProperties.CREATE_RESOURCE_BUNDLE_FILE_PATH"));
            }
            catch (CoreException e) {
                status = PortletCore.createErrorStatus((Exception)((Object)e));
            }
        }
        if (this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.CREATE_ENTRY_CLASS") && this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.ADD_TO_CONTROL_PANEL")) {
            try {
                NewEntryClassOperation entryClassOperation = new NewEntryClassOperation(this.getDataModel());
                entryClassOperation.execute(monitor, info);
            }
            catch (ExecutionException e) {
                status = PortletCore.createErrorStatus((Exception)((Object)e));
            }
        }
        if (this.getDataModel().getBooleanProperty("INewPortletClassDataModelProperties.CREATE_JSPS")) {
            status = this.createModeJSPFiles();
        }
        try {
            String javascriptFilePath;
            String cssFilePath = this.getDataModel().getStringProperty("INewPortletClassDataModelProperties.CSS_FILE");
            if (!CoreUtil.isNullOrEmpty((String)cssFilePath)) {
                this.createEmptyFileInDocroot(cssFilePath);
            }
            if (!CoreUtil.isNullOrEmpty((String)(javascriptFilePath = this.getDataModel().getStringProperty("INewPortletClassDataModelProperties.JAVASCRIPT_FILE")))) {
                this.createEmptyFileInDocroot(javascriptFilePath);
            }
        }
        catch (Exception ex) {
            status = PortletCore.createErrorStatus((Exception)ex);
        }
        return status;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.doExecute(monitor, info);
        if (!status.isOK()) {
            return status;
        }
        this.generateMetaData(this.getDataModel());
        return Status.OK_STATUS;
    }

    protected void createEmptyFileInDefaultSourceFolder(String filePath) throws CoreException {
        IFile projectFile;
        List sourceFolders = CoreUtil.getSourceFolders((IJavaProject)JavaCore.create((IProject)this.getTargetProject()));
        if (sourceFolders != null && sourceFolders.size() > 0 && !(projectFile = ((IFolder)sourceFolders.get(0)).getFile(filePath)).exists()) {
            IFolder parent = (IFolder)projectFile.getParent();
            CoreUtil.prepareFolder((IFolder)parent);
            projectFile.create((InputStream)new ByteArrayInputStream(new byte[0]), 1, null);
        }
    }

    protected void createEmptyFileInDocroot(String filePath) throws CoreException {
        IFile projectFile = this.getProjectFile(filePath);
        if (!projectFile.exists()) {
            CoreUtil.createEmptyFile((IFile)projectFile);
        }
    }

    protected IStatus createModeJSPFiles() {
        IDataModel dm = this.getDataModel();
        DocumentTemplateContext context = new DocumentTemplateContext(this.portletContextType, (IDocument)new Document(), 0, 0);
        context.setVariable("portlet_display_name", this.getDataModel().getStringProperty("INewPortletClassDataModelProperties.DISPLAY_NAME"));
        List initParams = (List)this.getDataModel().getProperty("INewPortletClassDataModelProperties.INIT_PARAMS");
        String initParamSuffix = null;
        initParamSuffix = initNames61[0].equals(((ParamValue)initParams.get(0)).getName()) ? "template" : "jsp";
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.ABOUT_MODE")) {
            this.createResourceForMode("about-" + initParamSuffix, "com.liferay.ide.templates.portlet.aboutjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.CONFIG_MODE")) {
            this.createResourceForMode("config-" + initParamSuffix, "com.liferay.ide.templates.portlet.configjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.EDIT_MODE")) {
            this.createResourceForMode("edit-" + initParamSuffix, "com.liferay.ide.templates.portlet.editjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.EDITDEFAULTS_MODE")) {
            this.createResourceForMode("edit-defaults-" + initParamSuffix, "com.liferay.ide.templates.portlet.editdefaultsjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.EDITGUEST_MODE")) {
            this.createResourceForMode("edit-guest-" + initParamSuffix, "com.liferay.ide.templates.portlet.editguestjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.HELP_MODE")) {
            this.createResourceForMode("help-" + initParamSuffix, "com.liferay.ide.templates.portlet.helpjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.PREVIEW_MODE")) {
            this.createResourceForMode("preview-" + initParamSuffix, "com.liferay.ide.templates.portlet.previewjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.PRINT_MODE")) {
            this.createResourceForMode("print-" + initParamSuffix, "com.liferay.ide.templates.portlet.printjsp", (TemplateContext)context);
        }
        if (dm.getBooleanProperty("INewPortletClassDataModelProperties.VIEW_MODE")) {
            this.createResourceForMode("view-" + initParamSuffix, "com.liferay.ide.templates.portlet.viewjsp", (TemplateContext)context);
        }
        return Status.OK_STATUS;
    }

    protected void createResourceForMode(String initParamName, String templateId, TemplateContext context) {
        Template template = this.templateStore.findTemplateById(templateId);
        String templateString = null;
        try {
            TemplateBuffer buffer = context.evaluate(template);
            templateString = buffer.getString();
        }
        catch (Exception ex) {
            PortletCore.logError((Exception)ex);
            return;
        }
        IFile viewJspFile = null;
        List initParams = (List)this.getDataModel().getProperty("INewPortletClassDataModelProperties.INIT_PARAMS");
        for (ParamValue paramValue : initParams) {
            if (!paramValue.getName().equals(initParamName)) continue;
            viewJspFile = this.getProjectFile(paramValue.getValue());
            break;
        }
        if (viewJspFile != null) {
            try {
                if (viewJspFile.exists()) {
                    viewJspFile.setContents((InputStream)new ByteArrayInputStream(templateString.getBytes("UTF-8")), 1, null);
                } else {
                    CoreUtil.prepareFolder((IFolder)((IFolder)viewJspFile.getParent()));
                    viewJspFile.create((InputStream)new ByteArrayInputStream(templateString.getBytes("UTF-8")), 1, null);
                }
            }
            catch (Exception ex) {
                PortletCore.logError((Exception)ex);
            }
        }
    }

    protected IStatus generateMetaData(IDataModel aModel) {
        if (this.shouldGenerateMetaData(aModel)) {
            IStatus status;
            IProject project = this.getTargetProject();
            if (aModel.getBooleanProperty("IPluginWizardFragmentProperties.REMOVE_EXISTING_ARTIFACTS")) {
                this.removeAllPortlets(project);
            }
            if (!(status = this.addNewPortlet(project, this.model)).isOK()) {
                PortletCore.getDefault().getLog().log(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    protected NewJavaEEArtifactClassOperation getNewClassOperation() {
        return new NewPortletClassOperation(this.getDataModel());
    }

    protected IFile getProjectFile(String filePath) {
        IFile retval = null;
        if (this.webappRoot != null) {
            retval = this.webappRoot.getFile((IPath)new Path(filePath));
        }
        return retval;
    }

    protected boolean shouldGenerateMetaData(IDataModel aModel) {
        return ProjectUtil.isPortletProject((IProject)this.getTargetProject());
    }

    protected IStatus removeAllPortlets(IProject project) {
        return ProjectCore.operate((IProject)project, RemoveAllPortletsOperation.class, (Object[])new Object[0]);
    }

    protected IStatus addNewPortlet(IProject project, IDataModel model) {
        return ProjectCore.operate((IProject)project, AddNewPortletOperation.class, (Object[])new Object[]{model});
    }
}

