/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.search.core.ISimpleXMLSearchEngine;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.internal.AbstractXMLSearchEngine;
import org.eclipse.wst.xml.search.core.internal.XMLSearchCorePlugin;
import org.eclipse.wst.xml.search.core.internal.reporter.XMLSearchReporterIdProvider;
import org.eclipse.wst.xml.search.core.namespaces.Namespaces;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;

public class SimpleXMLSearchEngine
extends AbstractXMLSearchEngine {
    private static final ISimpleXMLSearchEngine INSTANCE = new SimpleXMLSearchEngine();

    public static ISimpleXMLSearchEngine getDefault() {
        return INSTANCE;
    }

    @Override
    public IStatus search(IResource container, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        long startTime = -1L;
        int searchId = -1;
        if (this.isReporterEnabled(reporter)) {
            searchId = XMLSearchReporterIdProvider.getSearchId();
            startTime = System.currentTimeMillis();
            ArrayList<String> queries = new ArrayList<String>();
            queries.add(query);
            HashMap<IResource, Collection<String>> containersReporter = new HashMap<IResource, Collection<String>>();
            containersReporter.put(container, queries);
            reporter.beginSearch(searchId, containersReporter);
        }
        MultiStatus status = this.createStatus();
        try {
            this.search(container, container, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, monitor, status);
        }
        finally {
            if (searchId != -1) {
                reporter.endSearch(searchId, System.currentTimeMillis() - startTime);
            }
        }
        return status;
    }

    @Override
    public IStatus search(IResource[] containers, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        int i;
        long startTime = -1L;
        int searchId = -1;
        if (this.isReporterEnabled(reporter)) {
            searchId = XMLSearchReporterIdProvider.getSearchId();
            startTime = System.currentTimeMillis();
            HashMap<IResource, Collection<String>> containersReporter = new HashMap<IResource, Collection<String>>();
            if (containers != null) {
                ArrayList<String> queries = new ArrayList<String>();
                queries.add(query);
                i = 0;
                while (i < containers.length) {
                    containersReporter.put(containers[i], queries);
                    ++i;
                }
            }
            reporter.beginSearch(searchId, containersReporter);
        }
        MultiStatus status = this.createStatus();
        try {
            if (containers == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IResource container = null;
            i = 0;
            while (i < containers.length) {
                container = containers[i];
                this.search(container, container, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, monitor, status);
                ++i;
            }
        }
        finally {
            if (searchId != -1) {
                reporter.endSearch(searchId, System.currentTimeMillis() - startTime);
            }
        }
        return status;
    }

    private void search(IResource resource, IResource rootResource, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor, MultiStatus status) {
        if (this.acceptResource(resource, rootResource, requestor)) {
            int resourceType = resource.getType();
            switch (resourceType) {
                case 1: {
                    IFile file = (IFile)resource;
                    this.processFile(file, rootResource, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, status);
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    try {
                        IResource[] resources = ((IContainer)resource).members();
                        this.search(resources, rootResource, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, monitor, status);
                        break;
                    }
                    catch (CoreException e) {
                        status.add(XMLSearchCorePlugin.createStatus(4, e.getMessage(), e));
                    }
                }
            }
        }
    }

    private void search(IResource[] resources, IResource rootResource, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor, MultiStatus status) {
        int i = 0;
        while (i < resources.length) {
            this.search(resources[i], rootResource, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, monitor, status);
            ++i;
        }
    }

    @Override
    public IStatus search(IStorage storage, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        long startTime = -1L;
        int searchId = -1;
        if (this.isReporterEnabled(reporter)) {
            searchId = XMLSearchReporterIdProvider.getSearchId();
            startTime = System.currentTimeMillis();
        }
        MultiStatus status = this.createStatus();
        try {
            if (storage == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            super.processStorage(storage, storage, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, status);
        }
        finally {
            if (searchId != -1) {
                reporter.endSearch(searchId, System.currentTimeMillis() - startTime);
            }
        }
        return status;
    }

    private void search(IStorage storage, IStorage rootStorage, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IProgressMonitor monitor, MultiStatus status) {
        super.processStorage(storage, rootStorage, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, status);
    }

    @Override
    public IStatus search(IStorage[] storages, IXMLSearchRequestor requestor, IXMLSearchDOMDocumentVisitor visitor, String query, String xpathEvaluatorId, Namespaces namespaceInfos, IXMLSearchDOMNodeCollector collector, Object selectedNode, IXMLSearchReporter reporter, IProgressMonitor monitor) {
        long startTime = -1L;
        int searchId = -1;
        if (this.isReporterEnabled(reporter)) {
            searchId = XMLSearchReporterIdProvider.getSearchId();
            startTime = System.currentTimeMillis();
        }
        MultiStatus status = this.createStatus();
        try {
            if (storages == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStorage storage = null;
            int i = 0;
            while (i < storages.length) {
                storage = storages[i];
                super.processStorage(storage, storage, requestor, visitor, query, xpathEvaluatorId, namespaceInfos, collector, selectedNode, status);
                ++i;
            }
        }
        finally {
            if (searchId != -1) {
                reporter.endSearch(searchId, System.currentTimeMillis() - startTime);
            }
        }
        return status;
    }
}

