/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.search.core.IXMLSearchDOMNodeCollector;
import org.eclipse.wst.xml.search.core.XMLSearchEngine;
import org.eclipse.wst.xml.search.core.internal.FilesOfScopeCalculator;
import org.eclipse.wst.xml.search.core.internal.Messages;
import org.eclipse.wst.xml.search.core.queryspecifications.IExecutableXMLQuerySpecification;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;

public class XMLSearchEngine2
extends XMLSearchEngine {
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private int fNumberOfScannedFiles;

    @Override
    protected void search(IXMLQuerySpecificationRegistry querySpecificationRegistry, IXMLSearchDOMNodeCollector collector, IProgressMonitor monitor, MultiStatus status) {
        IFile[] files = this.evaluateFilesInScope(querySpecificationRegistry, status);
        if (files == null) {
            return;
        }
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(Messages.XMLSearchEngine2_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = XMLSearchEngine2.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(XMLSearchEngine2.this.fNumberOfScannedFiles), new Integer(XMLSearchEngine2.this.fNumberOfFilesToScan)};
                        monitor.subTask(NLS.bind((String)Messages.XMLSearchEngine2_scanning, (Object[])args));
                        int steps = XMLSearchEngine2.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        monitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            String taskName = NLS.bind((String)Messages.XMLSearchEngine2_textsearch_task_label, (Object)querySpecificationRegistry.getQueriesLabel());
            monitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.processFiles(files, null, querySpecificationRegistry, collector, monitor, status);
            }
            finally {
                monitorUpdateJob.cancel();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void processFiles(IFile[] files, IResource rootResource, IXMLQuerySpecificationRegistry querySpecificationRegistry, IXMLSearchDOMNodeCollector collector, IProgressMonitor monitor, MultiStatus status) {
        int i = 0;
        while (i < files.length) {
            this.fCurrentFile = files[i];
            boolean res = this.processFile(this.fCurrentFile, rootResource, querySpecificationRegistry, collector, monitor, status);
            if (!res) break;
            ++i;
        }
    }

    private boolean processFile(IFile file, IResource rootResource, IXMLQuerySpecificationRegistry querySpecificationRegistry, IXMLSearchDOMNodeCollector collector, IProgressMonitor monitor, MultiStatus status) {
        try {
            Collection<Collection<IExecutableXMLQuerySpecification>> all = querySpecificationRegistry.getQuerySpecificationsMap().values();
            for (Collection<IExecutableXMLQuerySpecification> collection : all) {
                super.processFile(file, rootResource, collection, collector, status);
            }
        }
        finally {
            ++this.fNumberOfScannedFiles;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.XMLSearchEngine2_canceled);
        }
        return true;
    }

    protected IFile[] evaluateFilesInScope(IXMLQuerySpecificationRegistry querySpecificationRegistry, MultiStatus status) {
        return new FilesOfScopeCalculator(querySpecificationRegistry, status).process();
    }

    static /* synthetic */ IFile access$0(XMLSearchEngine2 xMLSearchEngine2) {
        return xMLSearchEngine2.fCurrentFile;
    }

    static /* synthetic */ int access$1(XMLSearchEngine2 xMLSearchEngine2) {
        return xMLSearchEngine2.fNumberOfScannedFiles;
    }

    static /* synthetic */ int access$2(XMLSearchEngine2 xMLSearchEngine2) {
        return xMLSearchEngine2.fNumberOfFilesToScan;
    }
}

