/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.internal.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.search.core.internal.Trace;
import org.eclipse.wst.xml.search.core.storage.IStorageLocationProvider;
import org.eclipse.wst.xml.search.core.storage.IStorageModelManager;

public class StorageModelManager
implements IStorageModelManager {
    public static final IStorageModelManager INSTANCE = new StorageModelManager();
    private Map<IStorage, ModelInfo> modelInfoMap = new HashMap<IStorage, ModelInfo>();
    private IStorageLocationProvider locationProvider = null;

    @Override
    public IStructuredModel getModel(IStorage storage) {
        ModelInfo info = this.getModelInfoFor(storage);
        if (info != null) {
            return info.structuredModel;
        }
        IStructuredModel model = this.loadModel(storage);
        if (model != null) {
            this.modelInfoMap.put(storage, new ModelInfo(model, storage));
        }
        return model;
    }

    private IStructuredModel loadModel(IStorage storage) {
        IStructuredModel model;
        block18: {
            String id = this.calculateID(storage);
            if (id == null) {
                return null;
            }
            InputStream contents = null;
            model = null;
            try {
                try {
                    contents = storage.getContents();
                    model = StructuredModelManager.getModelManager().getModelForRead(id, contents, null);
                    model.setBaseLocation(this.calculateBaseLocation(storage));
                }
                catch (Exception exception) {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {
                        }
                        catch (Exception e) {
                            Trace.trace((byte)3, "StorageModelManager#loadModel", e);
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception e) {
                        Trace.trace((byte)3, "StorageModelManager#loadModel", e);
                    }
                }
                throw throwable;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "StorageModelManager#loadModel", e);
                }
            }
        }
        return model;
    }

    String calculateBaseLocation(IStorage storage) {
        String location = null;
        if (this.locationProvider != null) {
            location = this.locationProvider.getLocation(storage);
        }
        if (location != null) {
            return location;
        }
        try {
            try {
                if (storage != null) {
                    IPath storagePath = storage.getFullPath();
                    String name = storage.getName();
                    if (storagePath != null) {
                        if (!storagePath.lastSegment().equals(name)) {
                            IPath workingPath = storagePath.addTrailingSeparator();
                            location = workingPath.append(name).toString();
                        } else {
                            location = storagePath.makeAbsolute().toString();
                        }
                    }
                    if (location == null) {
                        location = name;
                    }
                }
            }
            catch (Throwable e) {
                Trace.trace((byte)3, "StorageModelManager#calculateBaseLocation", e);
                if (location == null) {
                    location = storage.getName();
                }
            }
        }
        finally {
            if (location == null) {
                location = storage.getName();
            }
        }
        return location;
    }

    String calculateID(IStorage storage) {
        String path;
        block13: {
            path = null;
            try {
                try {
                    if (storage != null) {
                        IPath storagePath = storage.getFullPath();
                        String name = storage.getName();
                        if (storagePath != null) {
                            if (!storagePath.lastSegment().equals(name)) {
                                IPath workingPath = storagePath.addTrailingSeparator();
                                path = workingPath.append(name).toString();
                            } else {
                                path = storagePath.makeAbsolute().toString();
                            }
                        }
                        if (path == null) {
                            path = name;
                        }
                    }
                }
                catch (Throwable e) {
                    Trace.trace((byte)3, "StorageModelManager#calculateID", e);
                    if (path == null) {
                        path = "";
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (path == null) {
                    path = "";
                }
                throw throwable;
            }
            if (path == null) {
                path = "";
            }
        }
        path = String.valueOf(storage.hashCode()) + "#" + path;
        return path;
    }

    @Override
    public IStorage getStorage(IStructuredModel model) {
        ModelInfo info = this.getModelInfoFor(model);
        if (info != null) {
            return info.storage;
        }
        return null;
    }

    private ModelInfo getModelInfoFor(IStorage storage) {
        ModelInfo result = this.modelInfoMap.get(storage);
        return result;
    }

    private ModelInfo getModelInfoFor(IStructuredModel structuredModel) {
        ModelInfo result = null;
        if (structuredModel != null) {
            ModelInfo[] modelInfos = this.modelInfoMap.values().toArray(new ModelInfo[0]);
            int i = 0;
            while (i < modelInfos.length) {
                ModelInfo info = modelInfos[i];
                if (structuredModel.equals(info.structuredModel)) {
                    result = info;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void setStorageLocationProvider(IStorageLocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    private class ModelInfo {
        public final IStructuredModel structuredModel;
        public final IStorage storage;

        public ModelInfo(IStructuredModel structuredModel, IStorage storage) {
            this.structuredModel = structuredModel;
            this.storage = storage;
        }
    }
}

