/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.util;

public class StringUtils {
    public static final String[] EMPTY_ARRAY = new String[0];

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        int lastIndex = string.length() - 1;
        char firstChar = string.charAt(0);
        char lastChar = string.charAt(lastIndex);
        return firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public static String normalizeSpace(String s) {
        char c;
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 1) {
            return "";
        }
        int st = 0;
        int off = 0;
        char[] val = s.toCharArray();
        int count = s.length();
        boolean parse = true;
        while (parse && off + st < count) {
            c = val[off + st];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            ++st;
        }
        parse = true;
        while (st < len && val[off + len - 1] <= ' ') {
            c = val[off + len - 1];
            parse = StringUtils.isParse(len, st, c);
            if (!parse) continue;
            --len;
        }
        return st > 0 || len < count ? s.substring(st, len) : s;
    }

    private static boolean isParse(int len, int st, char c) {
        return st < len && (c == ' ' || c == '\r' || c == '\n' || c == '\t');
    }
}

