/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.studio.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.studio.ui.IProductPreferences;
import com.liferay.ide.ui.snippets.util.SnippetsUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class StudioPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String ACCEPTED_EULA = "ACCEPTED_EULA";
    public static final String FIRST_LAUNCH_COMPLETE = "FIRST_LAUNCH_COMPLETE";
    public static final String IMPORTED_SNIPPET_FILES = "IMPORTED_SNIPPET_FILES";
    private static StudioPlugin plugin;
    public static final String PLUGIN_ID = "com.liferay.ide.studio.ui";
    public static final String PRODUCT_ID = "com.liferay.ide.studio.ui.product";

    public static boolean canInitLiferayWorkspace() {
        boolean retVal = false;
        try {
            File bundledPortalFile = new File(FileLocator.toFileURL((URL)new URL(IProductPreferences.BUNDLED_PORTAL_PATH_ZIP)).getFile());
            retVal = bundledPortalFile.exists();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static IStatus createErrorStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    public static IStatus createErrorStatus(String msg) {
        return new Status(4, PLUGIN_ID, msg);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, msg, (Throwable)e);
    }

    public static IStatus createInfoStatus(String msg) {
        return new Status(1, PLUGIN_ID, msg);
    }

    public static StudioPlugin getDefault() {
        return plugin;
    }

    public static boolean isProductRunning() {
        boolean productRunning = false;
        IProduct product = Platform.getProduct();
        if (product != null) {
            String id = product.getId();
            productRunning = PRODUCT_ID.equals(id);
        }
        return productRunning;
    }

    public static void logError(Exception e) {
        StudioPlugin.logError(e.getMessage(), e);
    }

    public static void logError(IStatus status) {
        StudioPlugin.getDefault().getLog().log(status);
    }

    public static void logError(String msg, Exception ex) {
        StudioPlugin.logError(StudioPlugin.createErrorStatus(msg, ex));
    }

    public static void logInfo(String msg) {
        StudioPlugin.getDefault().getLog().log(StudioPlugin.createInfoStatus(msg));
    }

    public void earlyStartup() {
        if (!StudioPlugin.isProductRunning()) {
            return;
        }
        this.importSnippets();
    }

    public IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    private void importSnippets() {
        block6: {
            try {
                Object[] snippetFiles;
                File snippetsImportDir;
                URL snippetsImportPath = FileLocator.resolve((URL)new URL(IProductPreferences.SNIPPETS_IMPORT_PATH));
                if (snippetsImportPath == null || !(snippetsImportDir = new File(snippetsImportPath.getFile())).exists() || !snippetsImportDir.isDirectory() || CoreUtil.isNullOrEmpty((Object[])(snippetFiles = snippetsImportDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name != null && name.endsWith(".xml");
                    }
                })))) break block6;
                Object[] objectArray = snippetFiles;
                int n = snippetFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Object snippetFile = objectArray[n2];
                    if (this.shouldImportFile((File)snippetFile)) {
                        try {
                            SnippetsUtil.importSnippetsFromFile((File)snippetFile);
                        }
                        catch (Exception ex) {
                            StudioPlugin.logError("Failed to import snippet file: " + ((File)snippetFile).getName(), ex);
                        }
                        this.storeFileImported((File)snippetFile);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isFirstLaunch() {
        IScopeContext[] scopes = new IScopeContext[]{ConfigurationScope.INSTANCE, InstanceScope.INSTANCE};
        return !Platform.getPreferencesService().getBoolean(PLUGIN_ID, FIRST_LAUNCH_COMPLETE, false, scopes);
    }

    private boolean shouldImportFile(File importFile) {
        Object[] fileNames;
        if (importFile == null || !importFile.exists() || !importFile.isFile()) {
            return false;
        }
        IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE};
        String importedSnippetFiles = Platform.getPreferencesService().getString(PLUGIN_ID, IMPORTED_SNIPPET_FILES, null, scopes);
        if (!CoreUtil.isNullOrEmpty((String)importedSnippetFiles) && !CoreUtil.isNullOrEmpty((Object[])(fileNames = importedSnippetFiles.split(",")))) {
            Object[] objectArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object fileName = objectArray[n2];
                if (((String)fileName).equals(importFile.getName())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void storeFileImported(File importedFile) {
        String importedSnippetFiles;
        if (importedFile == null) {
            return;
        }
        IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE};
        String newImportedSnippetFiles = importedSnippetFiles = Platform.getPreferencesService().getString(PLUGIN_ID, IMPORTED_SNIPPET_FILES, null, scopes);
        newImportedSnippetFiles = CoreUtil.isNullOrEmpty((String)importedSnippetFiles) ? importedFile.getName() : String.valueOf(importedSnippetFiles) + "," + importedFile.getName();
        this.getPreferences().put(IMPORTED_SNIPPET_FILES, newImportedSnippetFiles);
    }
}

