/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.studio.ui;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.splash.BasicSplashHandler;

public class StudioSplashHandler
extends BasicSplashHandler {
    private Font newFont;

    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(10, 10, 300, 15));
        this.setProgressRect(progressRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (Exception ex) {
            foregroundColorInteger = 13817855;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        if (PrefUtil.getInternalPreferenceStore().getBoolean("SHOW_BUILDID_ON_STARTUP")) {
            String buildId = System.getProperty("eclipse.buildId", "Unknown Build");
            String buildIdRect = product.getProperty("buildIdRect");
            Rectangle buildIdRectangle = StringConverter.asRectangle((String)buildIdRect, (Rectangle)new Rectangle(322, 190, 100, 40));
            GridLayout layout = new GridLayout(1, false);
            layout.marginRight = 0;
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            Composite versionComposite = new Composite(this.getContent(), 0);
            versionComposite.setBounds(buildIdRectangle);
            versionComposite.setLayout((Layout)layout);
            Label idLabel = new Label(versionComposite, 0);
            idLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
            idLabel.setForeground(this.getForeground());
            Font initialFont = idLabel.getFont();
            FontData[] fontData = initialFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(14);
                fontData[i].setStyle(1);
                ++i;
            }
            this.newFont = new Font((Device)idLabel.getDisplay(), fontData);
            idLabel.setFont(this.newFont);
            idLabel.setText(buildId);
            versionComposite.layout(true);
        } else {
            this.getContent();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.newFont != null && !this.newFont.isDisposed()) {
            this.newFont.dispose();
        }
    }
}

