/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core;

import com.liferay.ide.core.model.AbstractEditingModel;
import com.liferay.ide.core.model.IModelChangeProvider;
import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.ModelChangedEvent;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.portlet.core.IPluginPackageModel;
import com.liferay.ide.portlet.core.PluginPropertiesConfiguration;
import com.liferay.ide.portlet.core.PortletCore;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;

public class PluginPackageModel
extends AbstractEditingModel
implements IPluginPackageModel {
    private static final long serialVersionUID = 1L;
    PropertiesConfiguration pluginPackageProperties;

    public PluginPackageModel(IFile file, IDocument document, boolean isReconciling) {
        super(document, isReconciling);
        try {
            this.pluginPackageProperties = new PluginPropertiesConfiguration();
            InputStream is = file.getContents();
            this.pluginPackageProperties.load(is);
            is.close();
        }
        catch (Exception e) {
            PortletCore.logError(e);
        }
    }

    public void addDependency(String propertyName, String value) {
        String[] existingValues;
        if (CoreUtil.isNullOrEmpty((String)value)) {
            return;
        }
        String existingDeps = this.pluginPackageProperties.getString(propertyName, "");
        String[] stringArray = existingValues = existingDeps.split(",");
        int n = existingValues.length;
        int n2 = 0;
        while (n2 < n) {
            String existingValue = stringArray[n2];
            if (value.equals(existingValue)) {
                return;
            }
            ++n2;
        }
        String newDeps = null;
        newDeps = CoreUtil.isNullOrEmpty((String)existingDeps) ? value : String.valueOf(existingDeps) + "," + value;
        this.pluginPackageProperties.setProperty(propertyName, (Object)newDeps);
        this.flushProperties();
        this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, 1, (Object[])newDeps.split(","), propertyName));
    }

    public void addPortalDependencyJar(String jar) {
        this.addDependency("portal-dependency-jars", jar);
    }

    public void addPortalDependencyTld(String tldFile) {
        this.addDependency("portal-dependency-tlds", tldFile);
    }

    public void addPortalDeployExcludeJar(String jar) {
        this.addDependency("deploy-excludes", jar);
    }

    public void addRequiredDeploymentContext(String context) {
        this.addDependency("required-deployment-contexts", context);
    }

    public void adjustOffsets(IDocument document) throws CoreException {
    }

    public void dispose() {
        this.pluginPackageProperties = null;
    }

    public String getAuthor() {
        return this.getStringProperty("author");
    }

    public Boolean getBooleanProperty(String propertyName, boolean defaultVal) {
        if (this.pluginPackageProperties != null) {
            return this.pluginPackageProperties.getBoolean(propertyName, defaultVal);
        }
        return null;
    }

    public String getChangeLog() {
        return this.getStringProperty("change-log");
    }

    public String getLicenses() {
        return this.getStringProperty("licenses");
    }

    public String getLiferayVersions() {
        return this.getStringProperty("liferay-versions");
    }

    public String getLongDescription() {
        return this.getStringProperty("long-description");
    }

    public String getModuleGroupId() {
        return this.getStringProperty("module-group-id");
    }

    public String getModuleIncrementalVersion() {
        return this.getStringProperty("module-incremental-version");
    }

    public String getName() {
        return this.getStringProperty("name");
    }

    public String getPageUrl() {
        return this.getStringProperty("page-url");
    }

    public String[] getPortalDependencyJars() {
        String portalJars = this.pluginPackageProperties.getString("portal-dependency-jars", null);
        if (portalJars != null) {
            return portalJars.split(",");
        }
        return new String[0];
    }

    public String[] getPortalDependencyTlds() {
        String portalTlds = this.pluginPackageProperties.getString("portal-dependency-tlds", null);
        if (portalTlds != null) {
            return portalTlds.split(",");
        }
        return new String[0];
    }

    public String[] getPortalDeloyExcludesJars() {
        String exludeJars = this.pluginPackageProperties.getString("deploy-excludes", null);
        if (exludeJars != null) {
            return exludeJars.split(",");
        }
        return new String[0];
    }

    public String[] getRequiredDeploymentContexts() {
        String contexts = this.pluginPackageProperties.getString("required-deployment-contexts", null);
        if (contexts != null) {
            return contexts.split(",");
        }
        return new String[0];
    }

    public String getShortDescription() {
        return this.getStringProperty("short-description");
    }

    public String getStringProperty(String propertyName) {
        if (this.pluginPackageProperties != null && this.pluginPackageProperties.getProperty(propertyName) != null) {
            return this.pluginPackageProperties.getString(propertyName);
        }
        return null;
    }

    public String getTags() {
        return this.getStringProperty("tags");
    }

    public boolean isAdapterForType(Object type) {
        return type != null && INodeAdapter.class == type;
    }

    public Boolean isSpeedFiltersEnabled() {
        return this.getBooleanProperty("speed-filters-enabled", true);
    }

    public void load(InputStream source, boolean outOfSync) throws CoreException {
        this.pluginPackageProperties.clear();
        try {
            this.pluginPackageProperties.load(source);
            this.flushProperties();
            this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, 99, null, null));
        }
        catch (ConfigurationException e) {
            throw new CoreException(PortletCore.createErrorStatus((Exception)((Object)e)));
        }
    }

    public void removeDependency(String propertyName, String[] removedValues) {
        String[] deps;
        String portalDependencies = this.pluginPackageProperties.getString(propertyName, null);
        ArrayList<String> updatedValues = new ArrayList<String>();
        String[] stringArray = deps = portalDependencies.split(",");
        int n = deps.length;
        int n2 = 0;
        while (n2 < n) {
            String dep = stringArray[n2];
            if (dep.startsWith("**/WEB-INF/lib/")) {
                dep = dep.substring(dep.lastIndexOf("/") + 1);
            }
            boolean shouldKeep = true;
            String[] stringArray2 = removedValues;
            int n3 = removedValues.length;
            int n4 = 0;
            while (n4 < n3) {
                String removedValue = stringArray2[n4];
                if (dep.trim().equals(removedValue.trim())) {
                    shouldKeep = false;
                    break;
                }
                ++n4;
            }
            if (shouldKeep) {
                updatedValues.add(dep);
            }
            ++n2;
        }
        if (updatedValues.size() > 0) {
            this.pluginPackageProperties.setProperty(propertyName, (Object)"");
            for (String updatedValue : updatedValues) {
                this.addDependency(propertyName, updatedValue);
            }
        } else {
            this.pluginPackageProperties.clearProperty(propertyName);
        }
        this.flushProperties();
        this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, 2, updatedValues.toArray(), propertyName));
    }

    public void removePortalDependencyJars(String[] removedJars) {
        this.removeDependency("portal-dependency-jars", removedJars);
    }

    public void removePortalDependencyTlds(String[] removedTlds) {
        this.removeDependency("portal-dependency-tlds", removedTlds);
    }

    public void removePortalDeployExcludeJar(String[] removedJars) {
        this.removeDependency("deploy-excludes", removedJars);
    }

    public void removeRequiredDeploymentContexts(String[] contexts) {
        this.removeDependency("required-deployment-contexts", contexts);
    }

    public void setAuthor(String author) {
        this.setProperty("author", author);
    }

    public void setChangeLog(String changeLog) {
        this.setProperty("change-log", changeLog);
    }

    public void setLicenses(String licenses) {
        this.setProperty("licenses", licenses);
    }

    public void setLiferayVersions(String liferayVersions) {
        this.setProperty("liferay-versions", liferayVersions);
    }

    public void setLongDescription(String desc) {
        this.setProperty("long-description", desc);
    }

    public void setModuleGroupId(String moduleGroupId) {
        this.setProperty("module-group-id", moduleGroupId);
    }

    public void setModuleIncrementalVersion(String moduleIncrementalVersion) {
        this.setProperty("module-incremental-version", moduleIncrementalVersion);
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public void setPageUrl(String pageUrl) {
        this.setProperty("page-url", pageUrl);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        Object oldValue = this.pluginPackageProperties.getProperty(propertyName);
        this.pluginPackageProperties.setProperty(propertyName, propertyValue);
        this.flushProperties();
        this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, null, propertyName, oldValue, propertyValue));
    }

    public void setShortDescription(String desc) {
        this.setProperty("short-description", desc);
    }

    public void setSpeedFiltersEnabled(boolean enabled) {
        Boolean oldValue = this.isSpeedFiltersEnabled();
        this.pluginPackageProperties.setProperty("speed-filters-enabled", (Object)enabled);
        this.flushProperties();
        this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, null, "speed-filters-enabled", (Object)oldValue, (Object)enabled));
    }

    public void setTags(String tags) {
        this.setProperty("tags", tags);
    }

    public void swapDependencies(String property, String dep1, String dep2) {
        String[] deps = null;
        String depsValue = this.pluginPackageProperties.getString(property, null);
        deps = depsValue != null ? depsValue.split(",") : new String[]{};
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, deps);
        int index1 = list.indexOf(dep1);
        int index2 = list.indexOf(dep2);
        list.set(index2, dep1);
        list.set(index1, dep2);
        String[] newValues = list.toArray(new String[0]);
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = newValues;
        int n = newValues.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            buffer.append(String.valueOf(val) + ",");
            ++n2;
        }
        String newValue = buffer.toString().substring(0, buffer.length() - 1);
        this.pluginPackageProperties.setProperty(property, (Object)newValue);
        this.flushProperties();
        this.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)this, null, property, (Object)depsValue, (Object)newValue));
    }

    protected void flushProperties() {
        StringWriter output = new StringWriter();
        try {
            this.pluginPackageProperties.save((Writer)output);
            this.getDocument().set(output.toString());
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

