/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.model.CustomWindowState;
import com.liferay.ide.portlet.core.model.PortletApp;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;

public class WindowStatesPossibleValueService
extends PossibleValuesService {
    private static final String[] DEFAULT_STATES = new String[]{"maximized", "minimized", "normal"};
    private boolean initialized;
    private boolean readPriorToInit;
    private Set<String> values = Collections.emptySet();

    protected void compute(Set<String> values) {
        if (!this.initialized) {
            this.readPriorToInit = true;
        }
        values.addAll(this.values);
    }

    protected void initPossibleValuesService() {
        super.initPossibleValuesService();
        final PortletApp portletApp = (PortletApp)this.context(PortletApp.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WindowStatesPossibleValueService.this.refreshValues();
            }
        };
        portletApp.attach((Listener)listener, PortletApp.PROP_CUSTOM_WINDOW_STATES.name());
        this.refreshValues();
        portletApp.attach((Listener)new FilteredListener<ElementDisposeEvent>((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            protected void handleTypedEvent(ElementDisposeEvent event) {
                portletApp.detach(this.val$listener, PortletApp.PROP_CUSTOM_WINDOW_STATES.name());
            }
        });
        this.initialized = true;
    }

    private void refreshValues() {
        PortletApp portletApp = (PortletApp)this.context(PortletApp.class);
        if (portletApp != null && !portletApp.disposed()) {
            TreeSet<String> newValues = new TreeSet<String>();
            int i = 0;
            while (i < DEFAULT_STATES.length) {
                newValues.add(DEFAULT_STATES[i]);
                ++i;
            }
            ElementList<CustomWindowState> customWindowStates = portletApp.getCustomWindowStates();
            for (CustomWindowState iCustomWindowState : customWindowStates) {
                String customWindowState = iCustomWindowState.getWindowState().text(false);
                if (customWindowState == null) continue;
                newValues.add(customWindowState);
            }
            if (!this.values.equals(newValues)) {
                this.values = Collections.unmodifiableSet(newValues);
            }
            if (this.initialized || this.readPriorToInit) {
                this.refresh();
            }
        }
    }
}

