/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.util;

import com.liferay.ide.core.util.CoreUtil;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class PortletUtil {
    public static IPackageFragmentRoot getSourceFolder(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    public static String localeString(String text) {
        int dash = text.indexOf("-");
        String localeString = text.substring(dash + 1, text.length());
        return localeString.trim();
    }

    public static String localeDisplayString(String text) {
        int dash = text.indexOf("-");
        String localeDisplatString = text.substring(0, dash);
        return localeDisplatString.trim();
    }

    public static String buildLocaleDisplayString(String displayName, Locale locale) {
        StringBuilder builder = new StringBuilder(displayName);
        builder.append(" - ");
        builder.append(locale.toString());
        return builder.toString();
    }

    public static String convertIOToJavaFileName(IProject project, String value) {
        IClasspathEntry[] cpEntries;
        String rbIOFile = value.substring(value.lastIndexOf("/") + 1);
        IFile resourceBundleFile = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wroot = workspace.getRoot();
        IClasspathEntry[] iClasspathEntryArray = cpEntries = CoreUtil.getClasspathEntries((IProject)project);
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            if (3 == iClasspathEntry.getEntryKind()) {
                IPath entryPath = wroot.getFolder(iClasspathEntry.getPath()).getLocation();
                resourceBundleFile = wroot.getFileForLocation(entryPath = entryPath.append(rbIOFile));
                if (resourceBundleFile != null && resourceBundleFile.exists()) break;
            }
            ++n2;
        }
        String javaName = resourceBundleFile.getProjectRelativePath().toPortableString();
        if (javaName.indexOf(46) != -1) {
            javaName = value.substring(0, value.lastIndexOf(46));
            javaName = javaName.replace('/', '.');
        }
        return javaName;
    }

    public static String convertJavaToIoFileName(String value, String extension, String ... locales) {
        String strFileName = value.replace('.', '/');
        if (locales != null && locales.length > 0) {
            strFileName = String.valueOf(strFileName) + "_" + locales[0];
        }
        strFileName = String.valueOf(strFileName) + "." + extension;
        return strFileName;
    }

    public static String stripPrefix(String value) {
        String strippedValue = value;
        int colonIndex = value.indexOf(":");
        if (colonIndex != -1) {
            strippedValue = strippedValue.substring(colonIndex + 1, strippedValue.length());
        }
        return strippedValue;
    }

    public static String stripSuffix(String value) {
        String strippedValue = value;
        int colonIndex = value.indexOf(":");
        if (colonIndex != -1) {
            strippedValue = strippedValue.substring(0, colonIndex);
        }
        return strippedValue;
    }
}

