/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.navigator.PropertiesFile;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class EditPropertiesFileAction
extends SelectionProviderAction {
    protected Shell shell;

    public EditPropertiesFileAction(ISelectionProvider sp) {
        super(sp, "Edit Properties File");
    }

    public EditPropertiesFileAction(ISelectionProvider selectionProvider, String text) {
        this(null, selectionProvider, text);
    }

    public EditPropertiesFileAction(Shell shell, ISelectionProvider selectionProvider, String text) {
        super(selectionProvider, text);
        this.shell = shell;
        this.setEnabled(false);
    }

    public boolean accept(Object node) {
        return node instanceof PropertiesFile;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void perform(Object entry) {
        if (entry instanceof PropertiesFile) {
            PropertiesFile workflowEntry = (PropertiesFile)entry;
            FileStoreEditorInput editorInput = new FileStoreEditorInput(workflowEntry.getFileStore());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.openEditor((IEditorInput)editorInput, "com.liferay.ide.ui.editor.LiferayPortalPropertiesEditor");
            }
            catch (PartInitException e) {
                LiferayServerUI.logError("Error opening properties editor.", (Exception)((Object)e));
            }
        }
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Object obj = iterator.next();
        if (this.accept(obj)) {
            this.perform(obj);
        }
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof PropertiesFile) {
                PropertiesFile node = (PropertiesFile)obj;
                if (!this.accept(node)) continue;
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }
}

