/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.action;

import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.ui.action.AbstractServerRunningAction;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class RedeployAction
extends AbstractServerRunningAction {
    private ModuleServer[] selectedModules;

    @Override
    protected int getRequiredServerState() {
        return 6;
    }

    public void run(IAction action) {
        if (this.selectedModules == null) {
            return;
        }
        if (this.selectedModules != null) {
            ModuleServer[] moduleServerArray = this.selectedModules;
            int n = this.selectedModules.length;
            int n2 = 0;
            while (n2 < n) {
                final ModuleServer moduleServer = moduleServerArray[n2];
                final ILiferayServerBehavior liferayServerBehavior = (ILiferayServerBehavior)moduleServer.getServer().loadAdapter(ILiferayServerBehavior.class, null);
                if (liferayServerBehavior != null) {
                    Job redeployJob = new Job("Redeploying " + moduleServer.getModuleDisplayName()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                liferayServerBehavior.redeployModule(moduleServer.getModule());
                            }
                            catch (CoreException e) {
                                LiferayServerCore.logError((String)("Error redeploying " + moduleServer.getModuleDisplayName()), (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    redeployJob.setUser(true);
                    redeployJob.schedule();
                }
                ++n2;
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        boolean validServerState = true;
        if (!selection.isEmpty()) {
            ArrayList<ModuleServer> newModules = new ArrayList<ModuleServer>();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection obj = (IStructuredSelection)selection;
                for (ModuleServer moduleServer : obj) {
                    newModules.add(moduleServer);
                    boolean bl = validServerState = validServerState && (moduleServer.getServer().getServerState() & this.getRequiredServerState()) > 0;
                }
                this.selectedModules = newModules.toArray(new ModuleServer[0]);
                action.setEnabled(validServerState);
            }
        }
    }
}

