/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.bndtools.core;

import aQute.bnd.build.Project;
import com.liferay.ide.bndtools.core.BndtoolsCore;
import com.liferay.ide.core.BaseLiferayProject;
import com.liferay.ide.core.IBundleProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BndtoolsProject
extends BaseLiferayProject
implements IBundleProject {
    private static final String[] ignorePaths = new String[]{"generated"};
    private final Project bndProject;

    public BndtoolsProject(IProject project, Project bndProject) {
        super(project);
        this.bndProject = bndProject;
    }

    public String getBundleShape() {
        return "jar";
    }

    public IFile getDescriptorFile(String name) {
        return null;
    }

    public IPath getLibraryPath(String filename) {
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        return null;
    }

    public IPath getOutputBundle(boolean cleanBuild, IProgressMonitor monitor) throws CoreException {
        Path retval = null;
        try {
            Object buildFile;
            Object[] buildFiles;
            if (cleanBuild) {
                this.bndProject.clean();
            }
            if (!CoreUtil.isNullOrEmpty((Object[])(buildFiles = this.bndProject.getBuildFiles(true))) && ((File)(buildFile = buildFiles[0])).exists()) {
                retval = new Path(((File)buildFile).getCanonicalPath());
            }
        }
        catch (Exception e) {
            BndtoolsCore.logError("Unable to get output jar for " + this.getProject().getName(), e);
        }
        return retval;
    }

    public String getSymbolicName() throws CoreException {
        String retval = this.bndProject.getName();
        try {
            Collection names = this.bndProject.getBsns();
            if (names != null && names.size() > 0) {
                retval = (String)names.iterator().next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public boolean filterResource(IPath resourcePath) {
        return this.filterResource(resourcePath, ignorePaths);
    }

    public boolean isFragmentBundle() {
        IFile bndFile = this.getProject().getFile("bnd.bnd");
        if (bndFile.exists()) {
            try {
                String content = FileUtil.readContents((InputStream)bndFile.getContents());
                if (content.contains("Fragment-Host")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

