/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.forms.ActuatorDef;
import org.eclipse.sapphire.ui.forms.ActuatorPart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.ActuatorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.text.SapphireFormText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class ActuatorLinkPresentation
extends ActuatorPresentation {
    @Text(value="Actuator label not specified")
    private static LocalizableText labelNotSpecified;
    private SapphireActionPresentationManager actionPresentationManager;

    static {
        LocalizableText.init(ActuatorLinkPresentation.class);
    }

    public ActuatorLinkPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public void render() {
        Label imageControl;
        int hSpan;
        final ActuatorPart part = this.part();
        ActuatorDef def = part.definition();
        SapphireActionGroup actions = part.getActions();
        this.actionPresentationManager = new SapphireActionPresentationManager(this, actions);
        SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
        HorizontalAlignment hAlign = (HorizontalAlignment)((Object)def.getHorizontalAlignment().content());
        int hAlignCode = hAlign == HorizontalAlignment.LEFT ? 16384 : (hAlign == HorizontalAlignment.RIGHT ? 131072 : 0x1000000);
        int n = hSpan = (Boolean)def.getSpanBothColumns().content() != false ? 2 : 1;
        if (hSpan == 1) {
            Label spacer = new Label(this.composite(), 0);
            spacer.setLayoutData((Object)GridLayoutUtil.gd());
            spacer.setText("");
            this.register((Control)spacer);
        }
        ImageData image = part.image(16);
        final Composite composite = new Composite(this.composite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhalign(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), hSpan), 8), hAlignCode));
        composite.setLayout((Layout)GridLayoutUtil.glayout(image == null ? 1 : 2, 0, 0));
        this.register((Control)composite);
        if (image != null) {
            imageControl = new Label(composite, 0);
            imageControl.setImage(this.resources().image(image));
            imageControl.setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
            imageControl.setEnabled(part.enabled());
        } else {
            imageControl = null;
        }
        final SapphireFormText text = new SapphireFormText(composite, 0);
        text.setLayoutData(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000));
        keyboardActionPresentation.attach((Control)text);
        String label = part.label(CapitalizationType.FIRST_WORD_ONLY);
        label = label == null ? labelNotSpecified.text() : label;
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
        buf.append(label);
        buf.append("</a></p></form>");
        text.setText(buf.toString(), true, false);
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                SapphireActionHandler handler = part.handler();
                if (handler != null) {
                    handler.execute(ActuatorLinkPresentation.this);
                }
            }
        });
        text.setEnabled(part.enabled());
        this.attachPartListener(new Listener(){

            public void handle(Event event) {
                if (event instanceof ActuatorPart.EnablementChangedEvent) {
                    boolean enabled = part.enabled();
                    if (imageControl != null) {
                        imageControl.setEnabled(enabled);
                    }
                    text.setEnabled(enabled);
                } else if (event instanceof SapphirePart.LabelChangedEvent) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
                    buf.append(part.label(CapitalizationType.FIRST_WORD_ONLY));
                    buf.append("</a></p></form>");
                    text.setText(buf.toString(), true, false);
                    composite.getParent().layout(true, true);
                } else if (event instanceof SapphirePart.ImageChangedEvent && imageControl != null) {
                    imageControl.setImage(ActuatorLinkPresentation.this.resources().image(part.image(16)));
                }
            }
        });
        keyboardActionPresentation.render();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.actionPresentationManager != null) {
            this.actionPresentationManager.dispose();
            this.actionPresentationManager = null;
        }
    }
}

