package org.bndtools.core.ui.wizards.ds;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;

public class NewDSComponentWizard extends NewElementWizard {

    private NewDSComponentWizardPage fPage;
    private final boolean fOpenEditorOnFinish;

    public NewDSComponentWizard(NewDSComponentWizardPage page, boolean openEditorOnFinish) {
        setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        setWindowTitle(Messages.NewDSComponentWizard_title);

        fPage = page;
        fOpenEditorOnFinish = openEditorOnFinish;
    }

    public NewDSComponentWizard() {
        this(null, true);
    }

    /*
     * @see Wizard#createPages
     */
    @Override
    public void addPages() {
        super.addPages();
        if (fPage == null) {
            fPage = new NewDSComponentWizardPage();
            fPage.init(getSelection());
        }
        addPage(fPage);
    }

    /*(non-Javadoc)
     * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#canRunForked()
     */
    @Override
    protected boolean canRunForked() {
        return !fPage.isEnclosingTypeSelected();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#finishPage(org.eclipse.core.runtime.IProgressMonitor)
     */
    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        fPage.createType(monitor); // use the full progress monitor
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    @Override
    public boolean performFinish() {
        warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res) {
            IResource resource = fPage.getModifiedResource();
            if (resource != null) {
                selectAndReveal(resource);
                if (fOpenEditorOnFinish) {
                    openResource((IFile) resource);
                }
            }
        }
        return res;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#getCreatedElement()
     */
    @Override
    public IJavaElement getCreatedElement() {
        return fPage.getCreatedType();
    }

}
