/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.ui.util;

import com.liferay.ide.ui.LiferayUIPlugin;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.osgi.framework.Bundle;

public class UIUtil {
    public static void async(Runnable runnable) {
        if (runnable != null) {
            try {
                Display.getDefault().asyncExec(runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void async(final Runnable runnable, final long delay) {
        Runnable delayer = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UIUtil.async(runnable);
            }
        };
        UIUtil.async(delayer);
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    public static void executeCommand(String commandId, ISelection selection) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        EvaluationContext evaluationContext = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        evaluationContext.addVariable("selection", (Object)selection);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command migrate = commandService.getCommand(commandId);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.executeCommandInContext(ParameterizedCommand.generateCommand((Command)migrate, null), null, (IEvaluationContext)evaluationContext);
    }

    public static IViewPart findView(String viewId) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewPart view = page.findView(viewId);
                if (view != null) {
                    return view;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveShell() {
        final Shell[] retval = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                retval[0] = Display.getDefault().getActiveShell();
            }
        });
        return retval[0];
    }

    public static ImageDescriptor getPluginImageDescriptor(String symbolicName, String imagePath) {
        URL entry;
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && (entry = bundle.getEntry(imagePath)) != null) {
            return ImageDescriptor.createFromURL((URL)entry);
        }
        return null;
    }

    public static void postInfo(final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    public static void postInfoWithToggle(final String title, final String msg, final String toggleMessage, final boolean toggleState, final IPersistentPreferenceStore store, final String key) {
        if (store == null || key == null || store.getString(key).equals("never")) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (String)toggleMessage, (boolean)toggleState, (IPreferenceStore)store, (String)key);
                try {
                    if (dialog.getToggleState()) {
                        store.setValue(key, "never");
                        store.save();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static boolean promptQuestion(final String title, final String message) {
        final boolean[] retval = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                retval[0] = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)title, (String)message);
            }
        });
        return retval[0];
    }

    public static void refreshCommonView(final String viewId) {
        try {
            UIUtil.async(new Runnable(){

                @Override
                public void run() {
                    IViewPart viewPart = UIUtil.showView(viewId);
                    if (viewPart != null) {
                        CommonViewer viewer = (CommonViewer)viewPart.getAdapter(CommonViewer.class);
                        viewer.refresh(true);
                    }
                }
            });
        }
        catch (Exception e) {
            LiferayUIPlugin.logError("Unable to refresh view " + viewId, e);
        }
    }

    public static void refreshContent(ICommonContentExtensionSite site, final Object elementOrTreePath) {
        final NavigatorContentService s = (NavigatorContentService)site.getService();
        UIUtil.sync(new Runnable(){

            @Override
            public void run() {
                try {
                    CommonViewer viewer = (CommonViewer)s.getViewer();
                    viewer.refresh(true);
                    viewer.setExpandedState(elementOrTreePath, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            page.setPerspective(persp);
        }
    }

    public static IViewPart showView(String viewId) {
        try {
            return PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView(viewId);
        }
        catch (PartInitException e) {
            LiferayUIPlugin.logError((Exception)((Object)e));
            return null;
        }
    }

    public static void switchToLiferayPerspective(String perspectiveId, boolean confirm) {
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(perspectiveId);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && finalPersp.equals(currentPersp = page.getPerspective())) {
                return;
            }
            if (confirm && !UIUtil.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        UIUtil.replaceCurrentPerspective(finalPersp);
    }

    public static void sync(Runnable runnable) {
        if (runnable != null) {
            try {
                Display.getDefault().syncExec(runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

