/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.internal.launching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.ClasspathEntryDescriptor;
import org.eclipse.pde.core.IBundleClasspathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.tycho.m2e.internal.EmbeddedArtifacts;

public class PDEBundleClasspathResolver
implements IBundleClasspathResolver {
    private static final Logger log = LoggerFactory.getLogger(PDEBundleClasspathResolver.class);
    private static final int CLASSPATH_SCOPE = 1;
    private static final IClasspathManager buildpathManager = MavenJdtPlugin.getDefault().getBuildpathManager();

    public Map<IPath, Collection<IPath>> getAdditionalClasspathEntries(IJavaProject javaProject) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        LinkedHashMap<IPath, Collection<IPath>> result = new LinkedHashMap<IPath, Collection<IPath>>();
        List<IClasspathEntryDescriptor> cp = this.resolveMavenClasspath(javaProject, (IProgressMonitor)monitor);
        IProject project = javaProject.getProject();
        if (cp.isEmpty()) {
            return result;
        }
        IWorkspaceRoot workspace = project.getWorkspace().getRoot();
        Map<ArtifactKey, String> classpathMap = EmbeddedArtifacts.getEmbeddedArtifacts(project);
        for (IClasspathEntryDescriptor entry : cp) {
            String pathStr = this.getBundlePath(classpathMap, entry);
            if (pathStr == null || ".".equals(pathStr)) continue;
            Path path = new Path(pathStr);
            switch (entry.getEntryKind()) {
                case 2: {
                    this.addClasspathMap(result, (IPath)path, this.getBuildOutputLocation(workspace, entry.getPath().segment(0)));
                    break;
                }
                case 1: {
                    this.addClasspathMap(result, (IPath)path, entry.getPath());
                }
            }
        }
        return result;
    }

    private IPath getBuildOutputLocation(IWorkspaceRoot workspace, String projectName) {
        IProject project = workspace.getProject(projectName);
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        IResource outputFolder = workspace.findMember(facade.getOutputLocation());
        return outputFolder.getLocation();
    }

    private void addClasspathMap(Map<IPath, Collection<IPath>> result, IPath bundlePath, IPath location) {
        Collection<IPath> locations = result.get(bundlePath);
        if (locations == null) {
            locations = new LinkedHashSet<IPath>();
            result.put(bundlePath, locations);
        }
        locations.add(location);
    }

    public Collection<IRuntimeClasspathEntry> getAdditionalSourceEntries(IJavaProject javaProject) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        LinkedHashSet<IRuntimeClasspathEntry> resolved = new LinkedHashSet<IRuntimeClasspathEntry>();
        List<IClasspathEntryDescriptor> cp = this.resolveMavenClasspath(javaProject, (IProgressMonitor)monitor);
        if (cp.isEmpty()) {
            return resolved;
        }
        Map<ArtifactKey, String> classpathMap = EmbeddedArtifacts.getEmbeddedArtifacts(javaProject.getProject());
        for (IClasspathEntryDescriptor entry : cp) {
            if (!this.isBundleClasspathEntry(classpathMap, entry)) continue;
            switch (entry.getEntryKind()) {
                case 2: {
                    this.addProjectEntries(resolved, entry.getPath(), 1, PDEBundleClasspathResolver.getArtifactClassifier(entry), (IProgressMonitor)monitor);
                    break;
                }
                case 1: {
                    resolved.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath()));
                }
            }
        }
        return resolved;
    }

    protected List<IClasspathEntryDescriptor> resolveMavenClasspath(IJavaProject javaProject, IProgressMonitor monitor) {
        IProject project = javaProject.getProject();
        try {
            ArrayList<IClasspathEntryDescriptor> descriptors = new ArrayList<IClasspathEntryDescriptor>();
            IClasspathEntry[] iClasspathEntryArray = buildpathManager.getClasspath(project, 1, false, monitor);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                descriptors.add((IClasspathEntryDescriptor)new ClasspathEntryDescriptor(cpe));
                ++n2;
            }
            return descriptors;
        }
        catch (CoreException e) {
            log.debug("Could not resolve maven dependencies classpath container for project {}.", (Object)project.getName(), (Object)e);
            return Collections.emptyList();
        }
    }

    private String getBundlePath(Map<ArtifactKey, String> classpathMap, IClasspathEntryDescriptor entry) {
        Map attributes = entry.getClasspathAttributes();
        String g = (String)attributes.get("maven.groupId");
        String a = (String)attributes.get("maven.artifactId");
        String v = (String)attributes.get("maven.version");
        String c = (String)attributes.get("maven.classifier");
        return classpathMap.get(new ArtifactKey(g, a, v, c));
    }

    private boolean isBundleClasspathEntry(Map<ArtifactKey, String> classpathMap, IClasspathEntryDescriptor entry) {
        return this.getBundlePath(classpathMap, entry) != null;
    }

    protected void addProjectEntries(Set<IRuntimeClasspathEntry> resolved, IPath path, int scope, String classifier, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(path.segment(0));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        resolved.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject));
    }

    private static String getArtifactClassifier(IClasspathEntryDescriptor entry) {
        return (String)entry.getClasspathAttributes().get("maven.classifier");
    }
}

