/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.scripting.core;

import com.liferay.ide.scripting.core.ScriptingCore;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public abstract class GroovyScriptProxy
implements InvocationHandler {
    protected ClassLoader previousClassLoader;
    protected URLClassLoader proxyClassLoader;
    protected Object serviceObject;

    protected void configureClassloader() throws CoreException {
        ClassLoader currentClassLoader;
        if (this.proxyClassLoader == null) {
            this.proxyClassLoader = this.createClassLoader();
        }
        if ((currentClassLoader = Thread.currentThread().getContextClassLoader()).equals(this.proxyClassLoader)) {
            return;
        }
        this.previousClassLoader = currentClassLoader;
        Thread.currentThread().setContextClassLoader(this.proxyClassLoader);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable error;
        Object retval;
        block6: {
            retval = null;
            error = null;
            this.configureClassloader();
            try {
                try {
                    Object serviceObject = this.getServiceObject();
                    Method serviceMethod = serviceObject.getClass().getMethod(method.getName(), method.getParameterTypes());
                    retval = serviceMethod.invoke(serviceObject, args);
                }
                catch (Throwable t) {
                    ScriptingCore.logError("Error in script method " + method.getName(), t);
                    error = t;
                    this.unconfigureClassloader();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.unconfigureClassloader();
                throw throwable;
            }
            this.unconfigureClassloader();
        }
        if (error != null) {
            throw new RuntimeException("Error in workflow validation proxy.", error.getCause());
        }
        return retval;
    }

    protected URLClassLoader createClassLoader() throws CoreException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(ScriptingCore.getGroovyScriptingSupport().getGroovyLibURL());
        URL[] uRLArray = this.getProxyClasspath();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            urls.add(url);
            ++n2;
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Platform.class.getClassLoader());
    }

    protected void unconfigureClassloader() {
        if (this.previousClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.previousClassLoader);
        } else {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    protected Object getServiceObject() throws Exception {
        if (this.serviceObject == null) {
            this.serviceObject = ScriptingCore.getGroovyScriptingSupport().newInstanceFromFile(this.getGroovyFile());
        }
        return this.serviceObject;
    }

    protected abstract File getGroovyFile() throws Exception;

    protected abstract URL[] getProxyClasspath() throws CoreException;
}

