/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.common.ivyfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.FileUtil;

public class IvyFileUpdater {
    private static final String NL = System.getProperty("line.separator");

    public void addDependency(File ivyFile, String org, String name, String revision, String confMapping) throws IOException {
        ModuleRevisionId depId = new ModuleRevisionId(new ModuleId(org, name), revision);
        this.addDependency(ivyFile, depId, confMapping);
    }

    public void addDependency(File ivyFile, ModuleRevisionId depId, String confMapping) throws IOException {
        String content = FileUtil.readEntirely((File)ivyFile);
        UpdateInfo info = this.findUpdateInfoToAddDependency(content, depId, confMapping);
        this.update(ivyFile, content, info);
    }

    public void removeOrExcludeDependency(File ivyFile, ModuleId depId) throws IOException {
        String content = FileUtil.readEntirely((File)ivyFile);
        UpdateInfo info = this.findUpdateInfoToRemoveDependency(content, depId);
        if (info != null) {
            this.update(ivyFile, content, info);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(File ivyFile, String content, UpdateInfo info) throws FileNotFoundException {
        PrintWriter w = new PrintWriter(new FileOutputStream(ivyFile));
        try {
            w.print(content.substring(0, info.insertFromIndex));
            w.print(info.prefix);
            w.print(info.insert);
            w.print(info.suffix);
            w.print(content.substring(info.insertToIndex));
            w.flush();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            w.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
            w.close();
            return;
        }
    }

    private UpdateInfo findUpdateInfoToAddDependency(String content, ModuleRevisionId depId, String confMapping) {
        UpdateInfo info = new UpdateInfo();
        info.insert = this.getDependencyToAdd(depId, confMapping);
        Pattern dependenciesClose = Pattern.compile("<\\s*/dependencies");
        Matcher depsCloseMatcher = dependenciesClose.matcher(content);
        if (depsCloseMatcher.find()) {
            info.insertFromIndex = this.findLastDependencyEnd(content, depsCloseMatcher.start());
            if (info.insertFromIndex == -1) {
                info.insertFromIndex = this.getLastMatchIndex(Pattern.compile("<\\s*dependencies.*?>"), content, depsCloseMatcher.start());
                if (info.insertFromIndex == -1) {
                    info.insertFromIndex = depsCloseMatcher.start();
                } else {
                    info.prefix = IvyFileUpdater.NL;
                }
            } else {
                info.prefix = IvyFileUpdater.NL;
            }
            info.insertToIndex = info.insertFromIndex;
            return info;
        }
        Pattern depsOpenClose = Pattern.compile("<\\s*dependencies\\s*/>");
        Matcher depsOpenCloseMatcher = depsOpenClose.matcher(content);
        if (depsOpenCloseMatcher.find()) {
            info.insertFromIndex = depsOpenCloseMatcher.start();
            info.insertToIndex = depsOpenCloseMatcher.end();
            info.prefix = "<dependencies>" + IvyFileUpdater.NL;
            info.suffix = String.valueOf(IvyFileUpdater.NL) + "    </dependencies>";
            return info;
        }
        Pattern moduleClose = Pattern.compile("</\\s*ivy-module\\s*>");
        Matcher moduleCloseMatcher = moduleClose.matcher(content);
        if (moduleCloseMatcher.find()) {
            info.insertFromIndex = moduleCloseMatcher.start();
            info.insertToIndex = info.insertFromIndex;
            info.prefix = "    <dependencies>" + IvyFileUpdater.NL;
            info.suffix = String.valueOf(IvyFileUpdater.NL) + "    </dependencies>" + IvyFileUpdater.NL;
            return info;
        }
        return info;
    }

    private UpdateInfo findUpdateInfoToRemoveDependency(String content, ModuleId depId) {
        UpdateInfo info = new UpdateInfo();
        Matcher depsMatcher = Pattern.compile("<\\s*dependencies").matcher(content);
        if (!depsMatcher.find()) {
            return null;
        }
        Matcher depMatcher = Pattern.compile("<\\s*dependency\\s+.*name=[\"']([^\"']+)[\"']").matcher(content);
        int start = depsMatcher.start();
        while (depMatcher.find(start)) {
            if (depId.getName().equals(depMatcher.group(1))) {
                info.insertFromIndex = depMatcher.start();
                Matcher m = Pattern.compile("</\\s*dependency\\s*>").matcher(content);
                if (m.find(info.insertFromIndex)) {
                    info.insertToIndex = m.end();
                }
                if ((m = Pattern.compile("<\\s*dependency[^<]*?\\/\\>").matcher(content)).find(info.insertFromIndex)) {
                    info.insertToIndex = info.insertToIndex > 0 ? Math.min(info.insertToIndex, m.end()) : m.end();
                }
                info.insertFromIndex = this.findStartOfBlock(content, info.insertFromIndex);
                info.insertToIndex = this.findEndOfBlock(content, info.insertToIndex);
                return info;
            }
            start = depMatcher.end();
        }
        if (start == depsMatcher.start()) {
            return null;
        }
        Matcher depsCloseMatcher = Pattern.compile("<\\s*/dependencies").matcher(content);
        if (!depsCloseMatcher.find()) {
            return null;
        }
        info.insertFromIndex = this.findLastDependencyEnd(content, depsCloseMatcher.start());
        info.insertToIndex = info.insertFromIndex;
        info.prefix = IvyFileUpdater.NL;
        info.insert = this.getDependencyToExclude(depId);
        return info;
    }

    private int findLastDependencyEnd(String content, int end) {
        int depCloseIndex = this.getLastMatchIndex(Pattern.compile("</\\s*dependency\\s*>"), content, end);
        int depOpCloseIndex = this.getLastMatchIndex(Pattern.compile("\\<\\s*dependency.*?\\/\\>"), content, end);
        return Math.max(depCloseIndex, depOpCloseIndex);
    }

    private String getDependencyToAdd(ModuleRevisionId depId, String confMapping) {
        String dep = "        <dependency org=\"" + depId.getOrganisation() + "\"";
        dep = String.valueOf(dep) + " name=\"" + depId.getName() + "\"";
        dep = String.valueOf(dep) + " rev=\"" + depId.getRevision() + "\"";
        if (confMapping != null) {
            dep = String.valueOf(dep) + " conf=\"" + confMapping + "\"";
        }
        dep = String.valueOf(dep) + " />";
        return dep;
    }

    private String getDependencyToExclude(ModuleId depId) {
        String dep = "        <exclude org=\"" + depId.getOrganisation() + "\"";
        dep = String.valueOf(dep) + " module=\"" + depId.getName() + "\"";
        dep = String.valueOf(dep) + " />";
        return dep;
    }

    private int getLastMatchIndex(Pattern pattern, String content, int end) {
        Matcher matcher = pattern.matcher(content);
        int index = -1;
        while (matcher.find(index + 1)) {
            if (matcher.end() > end) {
                return index;
            }
            index = matcher.end();
        }
        return index;
    }

    private int findStartOfBlock(String content, int index) {
        --index;
        while (index >= 0) {
            char c = content.charAt(index);
            if (c != ' ' && c != '\t') {
                return index + 1;
            }
            --index;
        }
        return 0;
    }

    private int findEndOfBlock(String content, int index) {
        while (index < content.length()) {
            char c = content.charAt(index);
            if (c != ' ' && c != '\t') {
                if (c == '\n' || c == '\r') {
                    return index + 1;
                }
                return index;
            }
            ++index;
        }
        return index - 1;
    }

    private static final class UpdateInfo {
        private int insertFromIndex = 0;
        private int insertToIndex = 0;
        private String prefix = "";
        private String suffix = "";
        private String insert = "";

        private UpdateInfo() {
        }
    }
}

