/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.eclipse.cp.SettingsSetup;
import org.apache.ivyde.internal.eclipse.IvyMarkerManager;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerConfAdapter;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerState;
import org.apache.ivyde.internal.eclipse.ui.AdvancedSetupTab;
import org.apache.ivyde.internal.eclipse.ui.ClasspathSetupTab;
import org.apache.ivyde.internal.eclipse.ui.ConfTableViewer;
import org.apache.ivyde.internal.eclipse.ui.IvyFilePathText;
import org.apache.ivyde.internal.eclipse.ui.MappingSetupTab;
import org.apache.ivyde.internal.eclipse.ui.SettingsSetupTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class IvydeContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject project;
    private IvyFilePathText ivyFilePathText;
    private ConfTableViewer confTableViewer;
    private IvyClasspathContainerConfiguration conf;
    private IClasspathEntry entry;
    private TabFolder tabs;
    private boolean exported = false;
    private String oldIvyFile = null;
    private List oldConfs = null;
    private IvyClasspathContainerState state;
    private SettingsSetupTab settingsSetupTab;
    private ClasspathSetupTab classpathSetupTab;
    private MappingSetupTab mappingSetupTab;
    private AdvancedSetupTab advancedSetupTab;

    public IvydeContainerPage() {
        super("IvyDE Container");
    }

    public IJavaProject getProject() {
        return this.project;
    }

    void checkCompleted() {
        String error = null;
        if (this.ivyFilePathText.getIvyFilePath().length() == 0) {
            error = "Choose an ivy file";
        } else if (this.project != null) {
            error = this.checkConf();
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private String checkConf() {
        String error = null;
        String ivyFilePath = this.ivyFilePathText.getIvyFilePath();
        List selectedConfigurations = this.confTableViewer.getSelectedConfigurations();
        List containers = IvyClasspathContainerHelper.getContainers(this.project);
        if (containers == null) {
            return null;
        }
        Iterator itContainers = containers.iterator();
        while (error == null && itContainers.hasNext()) {
            IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)itContainers.next();
            IvyClasspathContainerConfiguration cpc = ivycp.getConf();
            if (this.oldIvyFile != null && cpc.getIvyXmlPath().equals(this.oldIvyFile) && this.oldConfs != null && this.oldConfs.size() == cpc.getConfs().size() && this.oldConfs.containsAll(cpc.getConfs()) || !cpc.getIvyXmlPath().equals(ivyFilePath)) continue;
            if (selectedConfigurations.isEmpty() || selectedConfigurations.contains("*") || cpc.getConfs().isEmpty() || cpc.getConfs().contains("*")) {
                error = "A container already exists for the selected conf of the module descriptor";
                continue;
            }
            ArrayList list = new ArrayList(cpc.getConfs());
            list.retainAll(selectedConfigurations);
            if (list.isEmpty()) continue;
            error = "A container already exists for the selected conf of the module descriptor";
        }
        return error;
    }

    void checkIvyXmlPath() {
        ModuleDescriptor md;
        try {
            md = this.state.getModuleDescriptor();
            this.ivyFilePathText.setIvyXmlError(null);
        }
        catch (IvyDEException e) {
            md = null;
            this.ivyFilePathText.setIvyXmlError(e);
        }
        this.confTableViewer.setModuleDescriptor(md);
        this.checkCompleted();
    }

    public boolean finish() {
        List<String> confs = this.confTableViewer.getSelectedConfigurations();
        if (confs.isEmpty()) {
            confs = Collections.singletonList("*");
        }
        this.conf.setConfs(confs);
        if (this.settingsSetupTab.isProjectSpecific()) {
            this.conf.setSettingsProjectSpecific(true);
            this.conf.setIvySettingsSetup(this.settingsSetupTab.getSettingsEditor().getIvySettingsSetup());
        } else {
            this.conf.setSettingsProjectSpecific(false);
        }
        if (this.classpathSetupTab.isProjectSpecific()) {
            this.conf.setClassthProjectSpecific(true);
            this.conf.setClasspathSetup(this.classpathSetupTab.getClasspathSetupEditor().getClasspathSetup());
        } else {
            this.conf.setClassthProjectSpecific(false);
        }
        if (this.mappingSetupTab.isProjectSpecific()) {
            this.conf.setMappingProjectSpecific(true);
            this.conf.setMappingSetup(this.mappingSetupTab.getMappingSetupEditor().getMappingSetup());
        } else {
            this.conf.setMappingProjectSpecific(false);
        }
        if (this.advancedSetupTab.isProjectSpecific()) {
            this.conf.setAdvancedProjectSpecific(true);
            this.conf.setAdvancedSetup(this.advancedSetupTab.getAdvancedSetupEditor().getAdvancedSetup());
        } else {
            this.conf.setAdvancedProjectSpecific(false);
        }
        IPath path = IvyClasspathContainerConfAdapter.getPath(this.conf);
        IClasspathAttribute[] atts = this.conf.getAttributes();
        this.entry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])atts, (boolean)this.exported);
        if (this.project != null) {
            try {
                IvyClasspathContainerImpl ivycp = new IvyClasspathContainerImpl(this.project, path, new IClasspathEntry[0], atts);
                JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{this.project}, (IClasspathContainer[])new IClasspathContainer[]{ivycp}, null);
                ivycp.launchResolve(false, null);
            }
            catch (JavaModelException e) {
                IvyPlugin.log((CoreException)((Object)e));
            }
        }
        if (this.conf.getJavaProject() != null && this.oldIvyFile != null && !this.oldIvyFile.equals(this.conf.getIvyXmlPath())) {
            IvyMarkerManager ivyMarkerManager = IvyPlugin.getDefault().getIvyMarkerManager();
            ivyMarkerManager.removeMarkers(this.conf.getJavaProject().getProject(), this.oldIvyFile);
        }
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.entry;
    }

    public void setSelection(IClasspathEntry entry) {
        if (entry == null) {
            this.conf = new IvyClasspathContainerConfiguration(this.project, "ivy.xml", true);
        } else {
            this.conf = new IvyClasspathContainerConfiguration(this.project, entry.getPath(), true, entry.getExtraAttributes());
            this.exported = entry.isExported();
        }
        this.state = new IvyClasspathContainerState(this.conf);
        this.oldIvyFile = this.conf.getIvyXmlPath();
        this.oldConfs = this.conf.getConfs();
    }

    public void setSelection(IFile ivyfile) {
        IResource settings;
        this.conf = new IvyClasspathContainerConfiguration(this.project, ivyfile.getProjectRelativePath().toString(), true);
        if (this.project != null && (settings = this.project.getProject().findMember((IPath)new Path("ivysettings.xml"))) != null) {
            this.conf.setSettingsProjectSpecific(true);
            SettingsSetup setup = new SettingsSetup();
            setup.setIvySettingsPath("ivysettings.xml");
            this.conf.setIvySettingsSetup(setup);
        }
        this.state = new IvyClasspathContainerState(this.conf);
    }

    public void createControl(Composite parent) {
        this.setTitle("IvyDE Managed Libraries");
        this.setDescription("Choose ivy file and its configurations.");
        this.tabs = new TabFolder(parent, 2048);
        this.tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem mainTab = new TabItem(this.tabs, 0);
        mainTab.setText("Main");
        mainTab.setControl(this.createMainTab((Composite)this.tabs));
        IProject p = this.project == null ? null : this.project.getProject();
        this.settingsSetupTab = new SettingsSetupTab(this.tabs, p){

            protected void settingsUpdated() {
                try {
                    IvydeContainerPage.this.conf.setSettingsProjectSpecific(this.isProjectSpecific());
                    IvydeContainerPage.this.conf.setIvySettingsSetup(this.getSettingsEditor().getIvySettingsSetup());
                    IvydeContainerPage.this.state.setIvySettingsLastModified(-1L);
                    IvydeContainerPage.this.state.getIvy();
                    this.getSettingsEditor().setSettingsError(null);
                    IvydeContainerPage.this.checkIvyXmlPath();
                }
                catch (IvyDEException e) {
                    this.getSettingsEditor().setSettingsError(e);
                }
            }
        };
        this.classpathSetupTab = new ClasspathSetupTab(this.tabs, p);
        this.mappingSetupTab = new MappingSetupTab(this.tabs, p);
        this.advancedSetupTab = new AdvancedSetupTab(this.tabs, p);
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IvydeContainerPage.this.ivyFilePathText.updateErrorMarker();
                IvydeContainerPage.this.settingsSetupTab.getSettingsEditor().updateErrorMarker();
            }
        });
        this.setControl((Control)this.tabs);
        this.loadFromConf();
        this.checkCompleted();
        this.tabs.setFocus();
    }

    private Control createMainTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite configComposite = new Composite(composite, 0);
        configComposite.setLayout((Layout)new GridLayout(2, false));
        configComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.ivyFilePathText = new IvyFilePathText(configComposite, 0, this.project == null ? null : this.project.getProject());
        this.ivyFilePathText.addListener(new IvyFilePathText.IvyXmlPathListener(){

            public void ivyXmlPathUpdated(String path) {
                IvydeContainerPage.this.conf.setIvyXmlPath(path);
                IvydeContainerPage.this.checkIvyXmlPath();
            }
        });
        this.ivyFilePathText.setLayoutData(new GridData(4, 2, true, false, 2, 1));
        Label confLabel = new Label(configComposite, 0);
        confLabel.setText("Configurations");
        this.confTableViewer = new ConfTableViewer(configComposite, 0);
        this.confTableViewer.setLayoutData(new GridData(4, 4, true, true));
        this.confTableViewer.addListener(new ConfTableViewer.ConfTableListener(){

            public void confTableUpdated(List confs) {
                IvydeContainerPage.this.checkCompleted();
            }
        });
        Button refreshConf = new Button(configComposite, 0);
        refreshConf.setLayoutData((Object)new GridData(3, 2, true, false, 2, 1));
        refreshConf.setText("Reload the list of configurations");
        refreshConf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ModuleDescriptor md;
                try {
                    md = IvydeContainerPage.this.state.getModuleDescriptor();
                }
                catch (IvyDEException e) {
                    md = null;
                    e.show(4, "Ivy configuration error", "The configurations of the ivy.xml could not be retrieved: ");
                }
                IvydeContainerPage.this.confTableViewer.setModuleDescriptor(md);
            }
        });
        return composite;
    }

    private void loadFromConf() {
        this.ivyFilePathText.init(this.conf.getIvyXmlPath());
        this.confTableViewer.init(this.conf.getConfs());
        this.settingsSetupTab.init(this.conf.isSettingsProjectSpecific(), this.conf.getIvySettingsSetup());
        this.classpathSetupTab.init(this.conf.isClassthProjectSpecific(), this.conf.getClasspathSetup());
        this.mappingSetupTab.init(this.conf.isMappingProjectSpecific(), this.conf.getMappingSetup());
        this.advancedSetupTab.init(this.conf.isAdvancedProjectSpecific(), this.conf.getAdvancedSetup(), this.project == null);
        this.settingsSetupTab.projectSpecificChanged();
        this.classpathSetupTab.projectSpecificChanged();
        this.mappingSetupTab.projectSpecificChanged();
        this.advancedSetupTab.projectSpecificChanged();
    }

    public void initialize(IJavaProject p, IClasspathEntry[] currentEntries) {
        this.project = p;
    }
}

