/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.core.sort.WarningNonMatchingVersionReporter;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.internal.eclipse.CachedIvy;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyMarkerManager;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolver;
import org.apache.ivyde.internal.eclipse.resolve.IvyRunner;
import org.apache.ivyde.internal.eclipse.resolve.ResolveRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class IvyResolveJob
extends Job {
    private static final int MONITOR_LENGTH = 1000;
    private static final int IVY_LOAD_LENGTH = 100;
    private static final int POST_RESOLVE_LENGTH = 100;
    private static final int WAIT_BEFORE_LAUNCH = 1000;
    private final List resolveQueue = new ArrayList();
    static /* synthetic */ Class class$0;

    public IvyResolveJob() {
        super("IvyDE resolve");
        this.setUser(false);
        this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus launchRequest(ResolveRequest request, IProgressMonitor monitor) {
        List list = this.resolveQueue;
        synchronized (list) {
            this.resolveQueue.add(request);
        }
        return this.run(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(ResolveRequest request) {
        List list = this.resolveQueue;
        synchronized (list) {
            this.resolveQueue.add(request);
        }
        this.schedule(1000L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            return this.doRun(monitor);
        }
        catch (RuntimeException e) {
            IvyDEMessage.error("Resolve job failed with an unexpected exception", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus doRun(IProgressMonitor monitor) {
        ResolveRequest request;
        Iterator itRequests;
        ArrayList toResolve;
        IvyDEMessage.info("Resolve job starting...");
        List list = this.resolveQueue;
        synchronized (list) {
            toResolve = new ArrayList(this.resolveQueue);
            this.resolveQueue.clear();
        }
        if (toResolve.isEmpty()) {
            IvyDEMessage.info("Nothing to resolve");
            return Status.OK_STATUS;
        }
        IvyDEMessage.verbose(String.valueOf(toResolve.size()) + " container(s) to resolve");
        monitor.beginTask("Loading ivy descriptors", 1000);
        LinkedHashMap<ModuleDescriptor, ArrayList<ResolveRequest>> inworkspaceModules = new LinkedHashMap<ModuleDescriptor, ArrayList<ResolveRequest>>();
        ArrayList<ResolveRequest> otherModules = new ArrayList<ResolveRequest>();
        HashMap<ResolveRequest, Ivy> ivys = new HashMap<ResolveRequest, Ivy>();
        HashMap<ResolveRequest, ModuleDescriptor> mds = new HashMap<ResolveRequest, ModuleDescriptor>();
        MultiStatus errorsStatus = new MultiStatus("org.apache.ivyde.eclipse", 4, "Some projects fail to be resolved", null);
        int step = 100 / toResolve.size();
        boolean forceFailOnError = false;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.apache.ivyde.internal.eclipse.resolve.IvyResolveJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            itRequests = toResolve.iterator();
            while (itRequests.hasNext()) {
                Object var18_21;
                ModuleDescriptor md;
                Ivy ivy;
                request = (ResolveRequest)itRequests.next();
                IvyDEMessage.info("Processing resolve request " + request.toString());
                forceFailOnError = forceFailOnError || request.isForceFailOnError();
                monitor.subTask("loading " + request.getResolver().toString());
                IProject project = request.getResolver().getProject();
                if (project != null && !project.isAccessible()) {
                    IvyDEMessage.warn("Skipping resolve on closed project " + project.getName());
                    monitor.worked(step);
                    continue;
                }
                IvyDEMessage.verbose("Loading ivysettings for " + request.toString());
                CachedIvy cachedIvy = request.getCachedIvy();
                try {
                    ivy = cachedIvy.getIvy();
                }
                catch (IvyDEException e) {
                    cachedIvy.setErrorMarker(e);
                    IvyDEMessage.error("Failed to configure Ivy for " + request + ": " + e.getMessage());
                    errorsStatus.add(e.asStatus(4, "Failed to configure Ivy for " + request));
                    monitor.worked(step);
                    continue;
                }
                cachedIvy.setErrorMarker(null);
                ivys.put(request, ivy);
                ivy.pushContext();
                try {
                    try {
                        md = cachedIvy.getModuleDescriptor(ivy);
                    }
                    catch (IvyDEException e) {
                        cachedIvy.setErrorMarker(e);
                        IvyDEMessage.error("Failed to load the descriptor for " + request + ": " + e.getMessage());
                        errorsStatus.add(e.asStatus(4, "Failed to load the descriptor for " + request));
                        monitor.worked(step);
                        var18_21 = null;
                        ivy.popContext();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var18_21 = null;
                    ivy.popContext();
                    throw throwable;
                }
                {
                    var18_21 = null;
                }
                ivy.popContext();
                cachedIvy.setErrorMarker(null);
                mds.put(request, md);
                if (request.isInWorkspace()) {
                    ArrayList<ResolveRequest> requests = (ArrayList<ResolveRequest>)inworkspaceModules.get(md);
                    if (requests == null) {
                        requests = new ArrayList<ResolveRequest>();
                        inworkspaceModules.put(md, requests);
                    }
                    requests.add(request);
                } else {
                    otherModules.add(request);
                }
                monitor.worked(step);
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
        {
            Object var20_27 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        step = 800 / toResolve.size();
        if (inworkspaceModules.isEmpty()) {
            IvyDEMessage.verbose("No module to resolve in workspace");
        } else {
            IvyDEMessage.info(String.valueOf(inworkspaceModules.size()) + " module(s) to resolve in workspace");
            ResolveRequest request2 = (ResolveRequest)((List)inworkspaceModules.values().iterator().next()).get(0);
            VersionMatcher versionMatcher = ((Ivy)ivys.get(request2)).getSettings().getVersionMatcher();
            WarningNonMatchingVersionReporter vReporter = new WarningNonMatchingVersionReporter();
            CircularDependencyStrategy circularDependencyStrategy = WarnCircularDependencyStrategy.getInstance();
            ModuleDescriptorSorter sorter = new ModuleDescriptorSorter(inworkspaceModules.keySet(), versionMatcher, (NonMatchingVersionReporter)vReporter, circularDependencyStrategy);
            List sortedModuleDescriptors = sorter.sortModuleDescriptors();
            Iterator it = sortedModuleDescriptors.iterator();
            while (it.hasNext()) {
                ModuleDescriptor module = (ModuleDescriptor)it.next();
                List requests = (List)inworkspaceModules.get(module);
                IvyDEMessage.info(String.valueOf(requests.size()) + " container(s) of module " + module + " to resolve in workspace");
                int i = 0;
                while (i < requests.size()) {
                    ModuleDescriptor md;
                    Ivy ivy;
                    request2 = (ResolveRequest)requests.get(i);
                    boolean canceled = this.launchResolveThread(request2, monitor, step, errorsStatus, ivy = (Ivy)ivys.get(request2), md = (ModuleDescriptor)mds.get(request2));
                    if (canceled) {
                        IvyDEMessage.warn("Resolve job canceled");
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
            }
        }
        if (otherModules.isEmpty()) {
            IvyDEMessage.verbose("No module to resolve outside the workspace");
        } else {
            IvyDEMessage.info(String.valueOf(otherModules.size()) + " module(s) to resolve outside the workspace");
            Iterator it = otherModules.iterator();
            while (it.hasNext()) {
                ModuleDescriptor md;
                Ivy ivy;
                request = (ResolveRequest)it.next();
                boolean canceled = this.launchResolveThread(request, monitor, step, errorsStatus, ivy = (Ivy)ivys.get(request), md = (ModuleDescriptor)mds.get(request));
                if (!canceled) continue;
                IvyDEMessage.warn("Resolve job canceled");
                return Status.CANCEL_STATUS;
            }
        }
        step = 100 / toResolve.size();
        monitor.setTaskName("Post resolve");
        itRequests = toResolve.iterator();
        while (true) {
            if (!itRequests.hasNext()) {
                if (errorsStatus.getChildren().length == 0) {
                    return Status.OK_STATUS;
                }
                if (!forceFailOnError && !IvyPlugin.getPreferenceStoreHelper().isErrorPopup()) {
                    return Status.OK_STATUS;
                }
                return errorsStatus;
            }
            request = (ResolveRequest)itRequests.next();
            if (!request.isResolveFailed()) {
                monitor.setTaskName(request.getResolver().toString());
                request.getResolver().postBatchResolve();
            }
            monitor.worked(step);
        }
    }

    private boolean launchResolveThread(ResolveRequest request, final IProgressMonitor monitor, final int step, MultiStatus errorsStatus, final Ivy ivy, final ModuleDescriptor md) {
        IvyRunner ivyRunner = new IvyRunner();
        final IStatus[] status = new IStatus[1];
        final IvyResolver resolver = request.getResolver();
        Runnable resolveRunner = new Runnable(){

            public void run() {
                status[0] = resolver.resolve(ivy, md, monitor, step);
            }
        };
        if (ivyRunner.launchIvyThread(resolveRunner, ivy, monitor)) {
            return true;
        }
        IvyMarkerManager ivyMarkerManager = IvyPlugin.getDefault().getIvyMarkerManager();
        ivyMarkerManager.setResolveStatus(status[0], resolver.getProject(), resolver.getIvyXmlPath());
        switch (status[0].getCode()) {
            case 8: {
                return true;
            }
            case 0: 
            case 1: {
                IvyDEMessage.info("Successuful resolve of " + request);
                break;
            }
            case 4: {
                IvyDEMessage.warn("Error on resolve of " + request + ": " + status[0].getMessage());
                request.setResolveFailed(true);
                errorsStatus.add(status[0]);
                break;
            }
            default: {
                IvyPlugin.logWarn("Unknown IStatus: " + status[0].getCode());
            }
        }
        return false;
    }
}

