/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.revdepexplorer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerConfiguration;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.revdepexplorer.MultiRevDependencyDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXException;

public class SyncIvyFilesJob
extends WorkspaceJob {
    private MultiRevDependencyDescriptor[] multiRevisionDependencies;

    public SyncIvyFilesJob(MultiRevDependencyDescriptor[] multiRevisionDependencies) {
        super("Synchronizing Ivy Files");
        this.multiRevisionDependencies = multiRevisionDependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus executeJob(IProgressMonitor monitor) {
        MultiStatus errorStatuses = new MultiStatus("org.apache.ivyde.eclipse", 4, "Failed to update one or more Ivy files.  See details.", null);
        IvyClasspathContainerImpl[] containers = this.getIvyClasspathContainers();
        int i = 0;
        while (i < containers.length) {
            block15: {
                IvyClasspathContainerImpl container = containers[i];
                ModuleDescriptor md = container.getState().getCachedModuleDescriptor();
                if (md != null) {
                    Object var13_19;
                    File ivyFile;
                    HashMap<ModuleRevisionId, String> newRevisions = new HashMap<ModuleRevisionId, String>();
                    DependencyDescriptor[] dependencies = md.getDependencies();
                    int j = 0;
                    while (j < dependencies.length) {
                        int k = 0;
                        while (k < this.multiRevisionDependencies.length) {
                            MultiRevDependencyDescriptor multiRevision = this.multiRevisionDependencies[k];
                            ModuleRevisionId dependencyRevisionId = dependencies[j].getDependencyRevisionId();
                            if (dependencies[j].getDependencyId().equals((Object)multiRevision.getModuleId()) && multiRevision.hasNewRevision() && multiRevision.isForContainer(container)) {
                                newRevisions.put(dependencyRevisionId, this.multiRevisionDependencies[k].getNewRevision());
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    UpdateOptions updateOptions = new UpdateOptions().setResolvedRevisions(newRevisions).setReplaceInclude(false).setGenerateRevConstraint(false).setNamespace((Namespace)new RevisionPreservingNamespace());
                    try {
                        ivyFile = container.getState().getIvyFile();
                    }
                    catch (IvyDEException e) {
                        errorStatuses.add((IStatus)new Status(4, "org.apache.ivyde.eclipse", 4, "Fail to resolve the ivy file", (Throwable)e));
                        break block15;
                    }
                    File ivyTempFile = new File(String.valueOf(ivyFile.toString()) + ".temp");
                    try {
                        try {
                            XmlModuleDescriptorUpdater.update((URL)ivyFile.toURI().toURL(), (File)ivyTempFile, (UpdateOptions)updateOptions);
                            this.saveChanges(container, ivyFile, ivyTempFile);
                        }
                        catch (MalformedURLException e) {
                            errorStatuses.add((IStatus)new Status(4, "org.apache.ivyde.eclipse", 4, "Failed to write Ivy file " + ivyFile + " (malformed URL)", (Throwable)e));
                        }
                        catch (IOException e) {
                            errorStatuses.add((IStatus)new Status(4, "org.apache.ivyde.eclipse", 4, "Failed to write Ivy file " + ivyFile, (Throwable)e));
                        }
                        catch (SAXException e) {
                            errorStatuses.add((IStatus)new Status(4, "org.apache.ivyde.eclipse", 4, "Failed to write Ivy file " + ivyFile, (Throwable)e));
                        }
                        var13_19 = null;
                        ivyTempFile.delete();
                    }
                    catch (Throwable throwable) {
                        var13_19 = null;
                        ivyTempFile.delete();
                        throw throwable;
                    }
                }
            }
            ++i;
        }
        if (errorStatuses.getChildren().length > 0) {
            return errorStatuses;
        }
        return Status.OK_STATUS;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IStatus status = Status.OK_STATUS;
        try {
            status = this.executeJob(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        return status;
    }

    private IvyClasspathContainerImpl[] getIvyClasspathContainers() {
        HashSet<IvyClasspathContainerImpl> containers = new HashSet<IvyClasspathContainerImpl>();
        int i = 0;
        while (i < this.multiRevisionDependencies.length) {
            MultiRevDependencyDescriptor multiRevision = this.multiRevisionDependencies[i];
            if (multiRevision.hasNewRevision()) {
                containers.addAll(Arrays.asList(multiRevision.getIvyClasspathContainers()));
            }
            ++i;
        }
        return containers.toArray(new IvyClasspathContainerImpl[containers.size()]);
    }

    private void saveChanges(IvyClasspathContainerImpl container, File permanentSaveTarget, File temporaryChanges) throws IOException {
        IvyClasspathContainerConfiguration conf = container.getConf();
        IFile virtualIvyFile = conf.getJavaProject().getProject().getFile(conf.getIvyXmlPath());
        IStatus writable = virtualIvyFile.getWorkspace().validateEdit(new IFile[]{virtualIvyFile}, IWorkspace.VALIDATE_PROMPT);
        if (writable.isOK()) {
            FileWriter writer = new FileWriter(permanentSaveTarget, false);
            BufferedReader reader = new BufferedReader(new FileReader(temporaryChanges));
            while (reader.ready()) {
                writer.write(String.valueOf(reader.readLine()) + "\n");
            }
            writer.flush();
            writer.close();
            reader.close();
        }
    }

    private class RevisionPreservingNamespace
    extends Namespace {
        private RevisionPreservingNamespace() {
        }

        public NamespaceTransformer getToSystemTransformer() {
            return new RevisionPreservingNamespaceTransformer();
        }

        private class NullableRevisionModuleRevisionId
        extends ModuleRevisionId {
            private String revision;

            public NullableRevisionModuleRevisionId(ModuleId moduleId, String revision) {
                super(moduleId, revision);
                this.revision = revision;
            }

            public String getRevision() {
                return this.revision;
            }
        }

        private class RevisionPreservingNamespaceTransformer
        implements NamespaceTransformer {
            private RevisionPreservingNamespaceTransformer() {
            }

            public boolean isIdentity() {
                return false;
            }

            public ModuleRevisionId transform(ModuleRevisionId mrid) {
                if (mrid.getRevision().indexOf("working@") > -1) {
                    return new NullableRevisionModuleRevisionId(mrid.getModuleId(), null);
                }
                return new ModuleRevisionId(mrid.getModuleId(), mrid.getRevision());
            }
        }
    }
}

